/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.util;

public final class BufferRecycler {
    protected final byte[][] mByteBuffers = new byte[ByteBufferType.values().length][];
    protected final char[][] mCharBuffers = new char[CharBufferType.values().length][];

    public byte[] allocByteBuffer(ByteBufferType type) {
        int ix = type.ordinal();
        byte[] buffer = this.mByteBuffers[ix];
        if (buffer == null) {
            buffer = this.balloc(type.size);
        } else {
            this.mByteBuffers[ix] = null;
        }
        return buffer;
    }

    public void releaseByteBuffer(ByteBufferType type, byte[] buffer) {
        this.mByteBuffers[type.ordinal()] = buffer;
    }

    public char[] allocCharBuffer(CharBufferType type) {
        return this.allocCharBuffer(type, 0);
    }

    public char[] allocCharBuffer(CharBufferType type, int minSize) {
        int ix;
        char[] buffer;
        if (type.size > minSize) {
            minSize = type.size;
        }
        if ((buffer = this.mCharBuffers[ix = type.ordinal()]) == null || buffer.length < minSize) {
            buffer = this.calloc(minSize);
        } else {
            this.mCharBuffers[ix] = null;
        }
        return buffer;
    }

    public void releaseCharBuffer(CharBufferType type, char[] buffer) {
        this.mCharBuffers[type.ordinal()] = buffer;
    }

    private byte[] balloc(int size) {
        return new byte[size];
    }

    private char[] calloc(int size) {
        return new char[size];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CharBufferType {
        TOKEN_BUFFER(2000),
        CONCAT_BUFFER(2000),
        TEXT_BUFFER(200),
        NAME_COPY_BUFFER(200);

        private final int size;

        private CharBufferType(int size) {
            this.size = size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ByteBufferType {
        READ_IO_BUFFER(4000),
        WRITE_IO_BUFFER(4000);

        private final int size;

        private ByteBufferType(int size) {
            this.size = size;
        }
    }
}

