/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JsonToken {
    NOT_AVAILABLE(null),
    START_OBJECT("{"),
    END_OBJECT("}"),
    START_ARRAY("["),
    END_ARRAY("]"),
    FIELD_NAME(null),
    VALUE_STRING(null),
    VALUE_NUMBER_INT(null),
    VALUE_NUMBER_FLOAT(null),
    VALUE_TRUE("true"),
    VALUE_FALSE("false"),
    VALUE_NULL("null");

    final String mSerialized;
    final char[] mSerializedChars;
    final byte[] mSerializedBytes;

    private JsonToken(String token) {
        if (token == null) {
            this.mSerialized = null;
            this.mSerializedChars = null;
            this.mSerializedBytes = null;
        } else {
            this.mSerialized = token;
            this.mSerializedChars = token.toCharArray();
            int len = this.mSerializedChars.length;
            this.mSerializedBytes = new byte[len];
            for (int i = 0; i < len; ++i) {
                this.mSerializedBytes[i] = (byte)this.mSerializedChars[i];
            }
        }
    }

    public String asString() {
        return this.mSerialized;
    }

    public char[] asCharArray() {
        return this.mSerializedChars;
    }

    public byte[] asByteArray() {
        return this.mSerializedBytes;
    }

    public boolean isNumeric() {
        return this == VALUE_NUMBER_INT || this == VALUE_NUMBER_FLOAT;
    }

    public boolean isScalarValue() {
        return this.ordinal() > FIELD_NAME.ordinal();
    }
}

