/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.codehaus.jackson.Base64Variant;
import org.codehaus.jackson.Base64Variants;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.JsonStreamContext;
import org.codehaus.jackson.ObjectCodec;
import org.codehaus.jackson.PrettyPrinter;

public abstract class JsonGenerator {
    protected PrettyPrinter _cfgPrettyPrinter;

    protected JsonGenerator() {
    }

    public abstract void enableFeature(Feature var1);

    public abstract void disableFeature(Feature var1);

    public final void setFeature(Feature f, boolean state) {
        if (state) {
            this.enableFeature(f);
        } else {
            this.disableFeature(f);
        }
    }

    public abstract boolean isFeatureEnabled(Feature var1);

    public abstract void setCodec(ObjectCodec var1);

    public abstract ObjectCodec getCodec();

    public final void setPrettyPrinter(PrettyPrinter pp) {
        this._cfgPrettyPrinter = pp;
    }

    public abstract void useDefaultPrettyPrinter();

    public abstract void writeStartArray() throws IOException, JsonGenerationException;

    public abstract void writeEndArray() throws IOException, JsonGenerationException;

    public abstract void writeStartObject() throws IOException, JsonGenerationException;

    public abstract void writeEndObject() throws IOException, JsonGenerationException;

    public abstract void writeFieldName(String var1) throws IOException, JsonGenerationException;

    public abstract void writeString(String var1) throws IOException, JsonGenerationException;

    public abstract void writeString(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(String var1) throws IOException, JsonGenerationException;

    public abstract void writeRaw(String var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRaw(char var1) throws IOException, JsonGenerationException;

    public abstract void writeRawValue(String var1) throws IOException, JsonGenerationException;

    public abstract void writeRawValue(String var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeRawValue(char[] var1, int var2, int var3) throws IOException, JsonGenerationException;

    public abstract void writeBinary(Base64Variant var1, byte[] var2, int var3, int var4) throws IOException, JsonGenerationException;

    public final void writeBinary(byte[] data, int offset, int len) throws IOException, JsonGenerationException {
        this.writeBinary(Base64Variants.getDefaultVariant(), data, offset, len);
    }

    public final void writeBinary(byte[] data) throws IOException, JsonGenerationException {
        this.writeBinary(Base64Variants.getDefaultVariant(), data, 0, data.length);
    }

    public abstract void writeNumber(int var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(long var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(BigInteger var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(double var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(float var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(BigDecimal var1) throws IOException, JsonGenerationException;

    public abstract void writeNumber(String var1) throws IOException, JsonGenerationException, UnsupportedOperationException;

    public abstract void writeBoolean(boolean var1) throws IOException, JsonGenerationException;

    public abstract void writeNull() throws IOException, JsonGenerationException;

    public abstract void writeObject(Object var1) throws IOException, JsonProcessingException;

    public abstract void writeTree(JsonNode var1) throws IOException, JsonProcessingException;

    public final void writeStringField(String fieldName, String value) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeString(value);
    }

    public final void writeBooleanField(String fieldName, boolean value) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeBoolean(value);
    }

    public final void writeNullField(String fieldName) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeNull();
    }

    public final void writeNumberField(String fieldName, int value) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeNumber(value);
    }

    public final void writeNumberField(String fieldName, long value) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeNumber(value);
    }

    public final void writeNumberField(String fieldName, double value) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeNumber(value);
    }

    public final void writeNumberField(String fieldName, float value) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeNumber(value);
    }

    public final void writeNumberField(String fieldName, BigDecimal value) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeNumber(value);
    }

    public final void writeArrayFieldStart(String fieldName) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeStartArray();
    }

    public final void writeObjectFieldStart(String fieldName) throws IOException, JsonGenerationException {
        this.writeFieldName(fieldName);
        this.writeStartObject();
    }

    public final void writeObjectField(String fieldName, Object pojo) throws IOException, JsonProcessingException {
        this.writeFieldName(fieldName);
        this.writeObject(pojo);
    }

    public abstract void copyCurrentEvent(JsonParser var1) throws IOException, JsonProcessingException;

    public abstract void copyCurrentStructure(JsonParser var1) throws IOException, JsonProcessingException;

    public abstract JsonStreamContext getOutputContext();

    public abstract void flush() throws IOException;

    public abstract void close() throws IOException;

    public abstract boolean isClosed();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        AUTO_CLOSE_TARGET(true),
        AUTO_CLOSE_JSON_CONTENT(true),
        QUOTE_FIELD_NAMES(true);

        final boolean _defaultState;

        public static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

