/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.util.Collections;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.RequestAcceptEncoding;
import org.apache.http.client.protocol.RequestAddCookies;
import org.apache.http.client.protocol.RequestClientConnControl;
import org.apache.http.client.protocol.RequestDefaultHeaders;
import org.apache.http.client.protocol.RequestExpectContinue;
import org.apache.http.client.protocol.ResponseContentEncoding;
import org.apache.http.client.protocol.ResponseProcessCookies;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.codehaus.httpcache4j.HTTPHost;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.resolver.ConnectionConfiguration;
import org.codehaus.httpcache4j.resolver.ResolverConfiguration;

public class HttpClientFactory {
    public CloseableHttpClient configure(HttpClientBuilder builder, ResolverConfiguration configuration) {
        builder.disableAuthCaching();
        ConnectionConfiguration config = configuration.getConnectionConfiguration();
        builder.setConnectionManager(this.configurationManager(config));
        SocketConfig.Builder socketConfig = SocketConfig.copy((SocketConfig)SocketConfig.DEFAULT);
        if (config.getSocketTimeout().isPresent()) {
            socketConfig.setSoTimeout(((Integer)config.getSocketTimeout().get()).intValue());
        }
        builder.setDefaultSocketConfig(socketConfig.build());
        ProxyAuthenticator proxyAuthenticator = configuration.getProxyAuthenticator();
        HTTPHost proxyHost = proxyAuthenticator.getConfiguration().getHost();
        RequestConfig requestC = this.requestConfig(proxyHost, config);
        builder.setDefaultRequestConfig(requestC);
        builder.setHttpProcessor(this.httpProcessor(configuration));
        return builder.build();
    }

    protected HttpProcessor httpProcessor(ResolverConfiguration configuration) {
        HttpProcessorBuilder b = HttpProcessorBuilder.create();
        b.addAll(new HttpRequestInterceptor[]{new RequestDefaultHeaders(Collections.emptyList()), new RequestContent(true), new RequestTargetHost(), new RequestClientConnControl(), new RequestUserAgent(configuration.getUserAgent()), new RequestExpectContinue()});
        b.add((HttpRequestInterceptor)new RequestAddCookies());
        b.add((HttpRequestInterceptor)new RequestAcceptEncoding());
        b.add((HttpResponseInterceptor)new ResponseProcessCookies());
        b.add((HttpResponseInterceptor)new ResponseContentEncoding());
        return b.build();
    }

    protected HttpClientConnectionManager configurationManager(ConnectionConfiguration config) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        if (config.getDefaultConnectionsPerHost().isPresent()) {
            connectionManager.setDefaultMaxPerRoute(((Integer)config.getDefaultConnectionsPerHost().get()).intValue());
        }
        if (config.getMaxConnections().isPresent()) {
            connectionManager.setMaxTotal(((Integer)config.getMaxConnections().get()).intValue());
        }
        for (Map.Entry entry : config.getConnectionsPerHost().entrySet()) {
            HTTPHost host = (HTTPHost)entry.getKey();
            connectionManager.setMaxPerRoute(new HttpRoute(new HttpHost(host.getHost(), host.getPort(), host.getScheme())), ((Integer)entry.getValue()).intValue());
        }
        return connectionManager;
    }

    protected RequestConfig requestConfig(HTTPHost proxyHost, ConnectionConfiguration config) {
        RequestConfig.Builder requestConfig = RequestConfig.copy((RequestConfig)RequestConfig.DEFAULT);
        if (config.getTimeout().isPresent()) {
            requestConfig.setConnectTimeout(((Integer)config.getTimeout().get()).intValue());
        }
        requestConfig.setAuthenticationEnabled(false);
        requestConfig.setStaleConnectionCheckEnabled(false);
        if (proxyHost != null) {
            requestConfig.setProxy(new HttpHost(proxyHost.getHost(), proxyHost.getPort(), proxyHost.getScheme()));
        }
        return requestConfig.build();
    }
}

