/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import com.google.common.io.OutputSupplier;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.codehaus.httpcache4j.cache.Key;
import org.codehaus.httpcache4j.util.DeletingFileFilter;

public final class FileManager
implements Serializable {
    private static final long serialVersionUID = -5273056780013227862L;
    private final File baseDirectory;

    public FileManager(File baseDirectory) {
        Preconditions.checkNotNull((Object)baseDirectory, (Object)"Base directory may not be null");
        this.baseDirectory = this.createFilesDirectory(baseDirectory);
    }

    public File getBaseDirectory() {
        return this.baseDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized File createFile(Key key, InputStream stream) throws IOException {
        File file = this.resolve(key);
        if (!file.getParentFile().exists()) {
            this.ensureDirectoryExists(file.getParentFile());
        }
        OutputSupplier outputStream = Files.newOutputStreamSupplier((File)file);
        try {
            ByteStreams.copy((InputStream)stream, (OutputSupplier)outputStream);
        }
        finally {
            Closeables.closeQuietly((Closeable)stream);
        }
        if (file.length() == 0L) {
            file.delete();
            file = null;
        }
        if (file != null && !file.exists()) {
            throw new IOException(String.format("Failed to create File '%s' for Key: %s", file.getName(), key));
        }
        return file;
    }

    public synchronized void clear() {
        this.baseDirectory.listFiles(new DeletingFileFilter());
    }

    public synchronized void remove(Key key) {
        File resolved = this.resolve(key);
        if (resolved.delete() && this.directoryIsEmpty(resolved.getParentFile())) {
            resolved.getParentFile().delete();
        }
    }

    public synchronized void clear(URI uri) {
        File resolved = this.resolve(uri);
        resolved.listFiles(new DeletingFileFilter());
        if (resolved.delete() && this.directoryIsEmpty(resolved.getParentFile())) {
            resolved.getParentFile().delete();
        }
    }

    public synchronized void ensureDirectoryExists(File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IllegalArgumentException(String.format("Directory %s did not exist, and could not be created", directory));
        }
    }

    public synchronized File resolve(Key key) {
        File uriFolder = this.resolve(key.getURI());
        String vary = key.getVary().isEmpty() ? "default" : Hashing.md5().hashString((CharSequence)key.getVary().toString(), Charsets.UTF_8).toString().trim();
        return new File(uriFolder, vary);
    }

    public synchronized File resolve(URI uri) {
        String uriHex = Hashing.md5().hashString((CharSequence)uri.toString(), Charsets.UTF_8).toString().trim();
        String distribution = uriHex.substring(0, 2);
        return new File(new File(this.baseDirectory, distribution), uriHex);
    }

    private boolean directoryIsEmpty(File directory) {
        String[] list;
        return directory.isDirectory() && ((list = directory.list()) == null || list.length == 0);
    }

    private File createFilesDirectory(File baseDirectory) {
        File files = new File(baseDirectory, "files");
        this.ensureDirectoryExists(files);
        return files;
    }
}

