/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.util;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeletingFileFilter
implements FileFilter {
    private final List<File> knownFiles = new ArrayList<File>();

    public DeletingFileFilter() {
    }

    public DeletingFileFilter(List<File> knownFiles) {
        Validate.notNull(knownFiles, (String)"Known files may not be null");
        this.knownFiles.addAll(knownFiles);
    }

    @Override
    public synchronized boolean accept(File pathname) {
        File[] files;
        if (!this.knownFiles.contains(pathname) && pathname.isFile()) {
            return !pathname.delete();
        }
        if (pathname.isDirectory() && ((files = pathname.listFiles(this)) == null || files.length == 0)) {
            return !pathname.delete();
        }
        return true;
    }
}

