/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.cache.FileResolver;
import org.codehaus.httpcache4j.cache.Key;
import org.codehaus.httpcache4j.util.DeletingFileFilter;
import org.codehaus.httpcache4j.util.StorageUtil;

final class FileManager
implements Serializable {
    private final FileResolver fileResolver;
    private static final long serialVersionUID = -5273056780013227862L;
    private final File baseDirectory;

    public FileManager(File baseDirectory) {
        Validate.notNull((Object)baseDirectory, (String)"Base directory may not be null");
        this.baseDirectory = baseDirectory;
        StorageUtil.ensureDirectoryExists(this.baseDirectory);
        File files = this.createFilesDirectory();
        this.fileResolver = new FileResolver(files);
    }

    private File createFilesDirectory() {
        File files = new File(this.baseDirectory, "files");
        StorageUtil.ensureDirectoryExists(files);
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File createFile(Key key, InputStream stream) throws IOException {
        File file = this.fileResolver.resolve(key);
        FileOutputStream outputStream = FileUtils.openOutputStream((File)file);
        try {
            IOUtils.copy((InputStream)stream, (OutputStream)outputStream);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
        if (file.length() == 0L) {
            file.delete();
            file = null;
        }
        return file;
    }

    void clear() {
        this.baseDirectory.listFiles(new DeletingFileFilter());
        this.createFilesDirectory();
    }
}

