/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.CacheControl;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.Seconds;

public class CacheItem {
    protected DateTime cachedTime;
    protected HTTPResponse response;
    protected int ttl;

    public CacheItem(HTTPResponse response) {
        this(response, new DateTime());
    }

    public CacheItem(HTTPResponse response, DateTime cachedTime) {
        Validate.notNull((Object)response, (String)"Response may not be null");
        Validate.notNull((Object)cachedTime, (String)"CacheTime may not be null");
        this.response = response;
        this.cachedTime = cachedTime;
        this.ttl = CacheItem.getTTL(response, 0);
    }

    public int getTTL() {
        return this.ttl;
    }

    public boolean isStale(HTTPRequest request) {
        if (this.response.hasPayload() && !this.response.getPayload().isAvailable()) {
            return true;
        }
        return this.ttl - this.getAge(request) <= 0;
    }

    public int getAge(HTTPRequest request) {
        return Seconds.secondsBetween((ReadableInstant)this.cachedTime, (ReadableInstant)request.getRequestTime()).getSeconds();
    }

    public static int getTTL(HTTPResponse response, int defaultTTLinSeconds) {
        DateTime date;
        DateTime expiryDate;
        int maxAge;
        CacheControl cc = response.getCacheControl();
        if (cc != null && (maxAge = cc.getMaxAge()) > 0) {
            return maxAge;
        }
        if (response.getExpires() != null && (expiryDate = response.getExpires()) != null && (date = response.getDate()) != null && date.isBefore((ReadableInstant)expiryDate)) {
            return Seconds.secondsBetween((ReadableInstant)date, (ReadableInstant)expiryDate).getSeconds();
        }
        return defaultTTLinSeconds;
    }

    public DateTime getCachedTime() {
        return this.cachedTime;
    }

    public HTTPResponse getResponse() {
        return this.response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheItem cacheItem = (CacheItem)o;
        if (this.cachedTime != null ? !this.cachedTime.equals((Object)cacheItem.cachedTime) : cacheItem.cachedTime != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals((Object)cacheItem.response) : cacheItem.response != null);
    }

    public int hashCode() {
        int result = this.cachedTime != null ? this.cachedTime.hashCode() : 0;
        result = 31 * result + (this.response != null ? this.response.hashCode() : 0);
        return result;
    }
}

