/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.cache.Vary;
import org.codehaus.httpcache4j.util.ToJSON;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class Key
implements Serializable,
ToJSON {
    private static final long serialVersionUID = 5827064595759738979L;
    private URI uri;
    private Vary vary;

    public static Key create(URI uri, Vary vary) {
        Validate.notNull((Object)uri, (String)"URI may not be null");
        Validate.notNull((Object)vary, (String)"vary may not be null");
        return new Key(uri, vary);
    }

    public static Key create(HTTPRequest request, HTTPResponse response) {
        URI uri = request.getRequestURI();
        return new Key(uri, Key.determineVariation(request.getAllHeaders(), response.getHeaders()));
    }

    private static Vary determineVariation(Headers responseHeaders, Headers requestHeaders) {
        String varyHeader = responseHeaders.getFirstHeaderValue("Vary");
        HashMap<String, String> resolvedVaryHeaders = new HashMap<String, String>();
        if (varyHeader != null) {
            String[] varies;
            String[] arr$ = varies = varyHeader.split(",");
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String vary;
                String value = requestHeaders.getFirstHeaderValue(vary = arr$[i$]);
                resolvedVaryHeaders.put(vary, value == null ? null : value);
            }
        }
        return new Vary(resolvedVaryHeaders);
    }

    Key(URI uri, Vary vary) {
        Validate.notNull((Object)uri, (String)"URI may not be null");
        Validate.notNull((Object)vary, (String)"Vary may not be null");
        this.uri = uri;
        this.vary = vary;
    }

    public URI getURI() {
        return this.uri;
    }

    public Vary getVary() {
        return this.vary;
    }

    public String toString() {
        return this.toJSON();
    }

    public String toJSON() {
        LinkedHashMap<String, String> object = new LinkedHashMap<String, String>();
        object.put("uri", this.uri.toString());
        object.put("vary", this.vary.toJSON());
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)o;
        if (this.uri != null ? !this.uri.equals(key.uri) : key.uri != null) {
            return false;
        }
        return !(this.vary != null ? !this.vary.equals(key.vary) : key.vary != null);
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (this.vary != null ? this.vary.hashCode() : 0);
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.toJSON());
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        String jsonValue = (String)in.readObject();
        Key key = this.fromJSON(jsonValue);
        this.uri = key.getURI();
        this.vary = key.getVary();
    }

    private Key fromJSON(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode node = mapper.readTree(json);
            URI uri = URI.create(node.path("uri").getValueAsText());
            Vary vary = Vary.fromJSON(node.path("vary").getValueAsText());
            return new Key(uri, vary);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

