/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.Headers;
import org.joda.time.DateTime;

public final class CacheItem
implements Serializable {
    private static final long serialVersionUID = 5891522215450656044L;
    private final DateTime cachedTime;
    private final HTTPResponse response;

    public CacheItem(HTTPResponse response) {
        this.response = response;
        this.cachedTime = new DateTime();
    }

    public boolean isStale() {
        if (this.response.hasPayload() && !this.response.getPayload().isAvailable()) {
            return true;
        }
        Headers headers = this.response.getHeaders();
        long now = new DateTime().getMillis();
        if (headers.hasHeader("Cache-Control")) {
            Header ccHeader = headers.getFirstHeader("Cache-Control");
            if (ccHeader.getValue().toLowerCase().contains("must-revalidate")) {
                return true;
            }
            Map directives = ccHeader.getDirectives();
            String maxAgeDirective = (String)directives.get("max-age");
            if (maxAgeDirective != null) {
                int maxAge = NumberUtils.toInt((String)maxAgeDirective, (int)-1);
                long age = now - this.cachedTime.getMillis();
                long remainingLife = (long)maxAge * 1000L - age;
                if (maxAge == -1 || remainingLife <= 0L) {
                    return true;
                }
            }
        }
        if (headers.hasHeader("Expires")) {
            long expiryDate = HeaderUtils.getHeaderAsDate((Header)headers.getFirstHeader("Expires"));
            long date = HeaderUtils.getHeaderAsDate((Header)headers.getFirstHeader("Date"));
            if (expiryDate == -1L || now >= expiryDate || date == expiryDate) {
                return true;
            }
        }
        return !headers.hasHeader("Cache-Control") && !headers.hasHeader("Expires");
    }

    public DateTime getCachedTime() {
        return this.cachedTime;
    }

    public HTTPResponse getResponse() {
        return this.response;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheItem cacheItem = (CacheItem)o;
        if (this.cachedTime != null ? !this.cachedTime.equals((Object)cacheItem.cachedTime) : cacheItem.cachedTime != null) {
            return false;
        }
        return !(this.response != null ? !this.response.equals((Object)cacheItem.response) : cacheItem.response != null);
    }

    public int hashCode() {
        int result = this.cachedTime != null ? this.cachedTime.hashCode() : 0;
        result = 31 * result + (this.response != null ? this.response.hashCode() : 0);
        return result;
    }
}

