/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.escenic.http.servlet.BasicAuthFilter;
import org.escenic.http.servlet.CacheControlFilter;
import org.escenic.http.servlet.DigestAuthFilter;
import org.escenic.http.servlet.ETagFilter;
import org.escenic.http.servlet.IfModifiedSinceFilter;
import org.escenic.http.servlet.RestServlet;

public class JettyServer {
    public static final int PORT = 10987;
    private final Server server;

    public JettyServer() {
        this(10987);
    }

    public JettyServer(int port) {
        this.server = new Server(port);
        ServletContextHandler context = new ServletContextHandler(1);
        this.addFilter(context, CacheControlFilter.class, "cc");
        this.addFilter(context, ETagFilter.class, "etag");
        this.addFilter(context, IfModifiedSinceFilter.class, "lm");
        this.addFilter(context, BasicAuthFilter.class, "basic");
        this.addFilter(context, DigestAuthFilter.class, "digest");
        context.addServlet(RestServlet.class, "/*");
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        this.server.setSendDateHeader(true);
        this.server.setStopAtShutdown(true);
    }

    private void addFilter(ServletContextHandler handler, Class filter, String pathSpec) {
        FilterHolder holder = new FilterHolder(filter);
        if (pathSpec != null) {
            holder.setInitParameter("path", pathSpec);
        }
        handler.addFilter(holder, "/*", 0);
    }

    public void start() {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        JettyServer server = new JettyServer();
        server.start();
        try {
            server.server.join();
        }
        catch (InterruptedException e) {
            server.stop();
        }
    }
}

