/*
 * Decompiled with CFR 0.152.
 */
package org.escenic.http.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.httpcache4j.Directives;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.QuotedDirective;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.escenic.http.Representation;
import org.escenic.http.servlet.AbstractEsiFilter;

public class DigestAuthFilter
extends AbstractEsiFilter {
    private static final String DIGEST = "Digest ";
    private static final String NONCE = "NONCE";
    private static final String NEXT_NONCE = "NEXT_NONCE";
    private static final String REALM = "TEST";

    public void doFilterImpl(HttpServletRequest pRequest, HttpServletResponse pResponse, FilterChain pChain, AbstractEsiFilter.PathElement pPath, Representation pRepresentation) throws IOException, ServletException {
        PasswordDigest digest = new PasswordDigest();
        Map<String, String> parameters = pPath.getParameters();
        String user = parameters.get("u");
        String pass = parameters.get("p");
        if (StringUtils.isBlank((String)user) && StringUtils.isBlank((String)pass)) {
            this.sendAuthorization(pResponse);
        } else {
            String authorization = pRequest.getHeader("Authorization");
            if (StringUtils.isNotBlank((String)authorization)) {
                AuthScheme scheme = new AuthScheme(new Header("Authorization", authorization));
                Directives directives = scheme.getDirectives();
                String nonce = directives.get("nonce");
                String response = directives.get("response");
                Algorithm algorithm = Algorithm.valueOf(directives.get("algorithm"));
                String username = directives.get("username");
                String realm = directives.get("realm");
                String method = pRequest.getMethod();
                String uri = directives.get("uri");
                if (uri == null) {
                    uri = pRequest.getRequestURI();
                }
                if (user.equals(username)) {
                    String ha1 = digest.digest(algorithm, user, realm, pass);
                    String correctresponse = digest.calculateResponse(algorithm, uri, method, nonce, ha1);
                    if (response.equals(correctresponse)) {
                        pResponse.setHeader("Authentication-Info", String.format("nextnonce=\"%s\"", NEXT_NONCE));
                        pChain.doFilter((ServletRequest)pRequest, (ServletResponse)pResponse);
                    } else {
                        this.sendAuthorization(pResponse);
                    }
                } else {
                    this.sendAuthorization(pResponse);
                }
            } else {
                this.sendAuthorization(pResponse);
            }
        }
    }

    private void sendAuthorization(HttpServletResponse pResponse) {
        ArrayList<QuotedDirective> directives = new ArrayList<QuotedDirective>();
        directives.add(new QuotedDirective("realm", REALM));
        directives.add(new QuotedDirective("nonce", NONCE));
        directives.add(new QuotedDirective("algorithm", Algorithm.MD5.name()));
        Directives dirs = new Directives(directives);
        pResponse.addHeader("WWW-Authenticate", DIGEST + dirs.toString());
        pResponse.setStatus(401);
    }

    private static class PasswordDigest {
        private PasswordDigest() {
        }

        public String digest(Algorithm pAlgorithm, String pUsername, String pRealm, String pPassword) {
            StringBuilder builder = new StringBuilder();
            builder.append(pUsername);
            builder.append(':');
            builder.append(pRealm);
            builder.append(':');
            builder.append(pPassword);
            return this.hash(pAlgorithm, builder.toString());
        }

        public String calculateResponse(Algorithm algorithm, String uri, String method, String nonce, String pHA1) {
            String HA2 = this.calculateHA2(algorithm, uri, method);
            return this.hash(algorithm, String.format("%s:%s:%s", pHA1, nonce, HA2));
        }

        private String hash(Algorithm pAlgorithm, String pStringToHash) {
            switch (pAlgorithm) {
                case SHA1: {
                    return DigestUtils.shaHex((String)pStringToHash);
                }
            }
            return DigestUtils.md5Hex((String)pStringToHash);
        }

        private String calculateHA2(Algorithm pAlgorithm, String pUri, String pMethod) {
            return this.hash(pAlgorithm, String.format("%s:%s", pMethod, pUri));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Algorithm {
        MD5,
        SHA1;

    }
}

