/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.codehaus.httpcache4j.Challenge;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.AuthenticatorBase;
import org.codehaus.httpcache4j.auth.AuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.auth.ProxyConfiguration;
import org.codehaus.httpcache4j.util.Pair;

public class DefaultProxyAuthenticator
extends AuthenticatorBase
implements ProxyAuthenticator {
    private final ProxyConfiguration configuration;
    private Challenge proxyChallenge;

    public DefaultProxyAuthenticator() {
        this(new ProxyConfiguration());
    }

    public DefaultProxyAuthenticator(ProxyConfiguration configuration) {
        this.configuration = configuration;
    }

    public DefaultProxyAuthenticator(ProxyConfiguration configuration, List<AuthenticatorStrategy> strategies) {
        super(strategies);
        this.configuration = Objects.requireNonNull(configuration, "Configuration may not be null");
    }

    @Override
    public final HTTPRequest prepareAuthentication(HTTPRequest request, HTTPResponse response) {
        if (this.configuration.getHost() != null) {
            if (response == null && this.registry.matches(this.configuration.getHost())) {
                AuthScheme authScheme = this.registry.get(this.configuration.getHost());
                return this.doAuth(request, Arrays.asList(authScheme));
            }
            if (response != null && response.getStatus() == Status.PROXY_AUTHENTICATION_REQUIRED) {
                if (this.proxyChallenge == null) {
                    this.proxyChallenge = this.configuration.getProvider().getChallenge();
                }
                if (this.proxyChallenge != null) {
                    List<AuthScheme> schemes = this.toAuthSchemes(response, "Proxy-Authenticate");
                    return this.doAuth(request, schemes);
                }
            }
        }
        return request;
    }

    @Override
    public boolean canAuthenticatePreemptively() {
        return this.canAuthenticatePreemptively(this.configuration.getHost());
    }

    @Override
    public HTTPRequest preparePreemptiveAuthentication(HTTPRequest request) {
        return this.prepareAuthentication(request, null);
    }

    private HTTPRequest doAuth(HTTPRequest request, List<AuthScheme> schemes) {
        Pair<AuthenticatorStrategy, AuthScheme> selected;
        if (!this.configuration.isHostIgnored(request.getRequestURI().getHost()) && (selected = this.select(schemes)).getValue() != null) {
            HTTPRequest req = selected.getKey().prepareWithProxy(request, this.proxyChallenge, selected.getValue());
            if (req != request) {
                this.registry.register(this.configuration.getHost(), selected.getValue());
            }
            return req;
        }
        return request;
    }

    @Override
    public void afterSuccessfulAuthentication(Headers responseHeaders) {
        if (this.registry.matches(this.configuration.getHost())) {
            AuthScheme scheme = this.registry.get(this.configuration.getHost());
            this.select(Arrays.asList(scheme)).getKey().afterSuccessfulProxyAuthentication(scheme, responseHeaders);
        }
    }

    @Override
    public void afterFailedAuthentication(Headers responseHeaders) {
        this.invalidateAuthentication();
        this.registry.remove(this.configuration.getHost());
    }

    @Override
    public void invalidateAuthentication() {
        this.proxyChallenge = null;
    }

    @Override
    public ProxyConfiguration getConfiguration() {
        return this.configuration;
    }
}

