/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.codehaus.httpcache4j.CacheHeaderBuilder;
import org.codehaus.httpcache4j.HTTPException;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.StatusLine;
import org.codehaus.httpcache4j.payload.InputStreamPayload;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.util.ThrowableFunction;

public final class HTTPResponse {
    private final StatusLine statusLine;
    private final Optional<Payload> payload;
    private final Headers headers;
    private final boolean cached;

    public HTTPResponse(Status status, Headers headers) {
        this(Optional.empty(), new StatusLine(status), headers);
    }

    public HTTPResponse(Optional<Payload> payload, Status status, Headers headers) {
        this(payload, new StatusLine(status), headers);
    }

    public HTTPResponse(Optional<Payload> payload, StatusLine statusLine, Headers headers) {
        this.statusLine = Objects.requireNonNull(statusLine, "You must supply a Status");
        this.payload = Objects.requireNonNull(payload, "We need an optional payload, not null");
        this.headers = Objects.requireNonNull(headers, "You must supply some Headers");
        if (headers.contains("X-Cache")) {
            Header cacheHeader = CacheHeaderBuilder.getBuilder().createHITXCacheHeader();
            List<Header> xcacheHeaders = headers.getHeaders("X-Cache");
            this.cached = xcacheHeaders.contains(cacheHeader);
        } else {
            this.cached = false;
        }
    }

    public HTTPResponse withHeaders(Headers headers) {
        return new HTTPResponse(this.payload, this.statusLine, headers);
    }

    public HTTPResponse withPayload(Payload payload) {
        return new HTTPResponse(Optional.ofNullable(payload), this.statusLine, this.headers);
    }

    public boolean hasPayload() {
        return this.payload.isPresent();
    }

    public Status getStatus() {
        return this.statusLine.getStatus();
    }

    public StatusLine getStatusLine() {
        return this.statusLine;
    }

    public Optional<Payload> getPayload() {
        return this.payload;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public boolean isCached() {
        return this.cached;
    }

    public <A> Optional<A> transform(ThrowableFunction<Payload, A, IOException> f) {
        if (this.hasPayload()) {
            return this.payload.flatMap(p -> this.lift((Payload)p, f));
        }
        return Optional.empty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <A> Optional<A> lift(Payload p, ThrowableFunction<Payload, A, IOException> f) {
        try (InputStream is = p.getInputStream();){
            InputStreamPayload isp = new InputStreamPayload(is, p.getMimeType(), p.length());
            Optional<Payload> optional = Optional.ofNullable(f.apply(isp));
            return optional;
        }
        catch (IOException e) {
            throw new HTTPException(e);
        }
    }

    public void consume() {
        this.payload.ifPresent(p -> {
            try (InputStream is = p.getInputStream();){
                if (null != is) {
                    is.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPResponse response = (HTTPResponse)o;
        if (this.headers != null ? !this.headers.equals(response.headers) : response.headers != null) {
            return false;
        }
        if (this.payload != null ? !this.payload.equals(response.payload) : response.payload != null) {
            return false;
        }
        return this.statusLine == response.statusLine;
    }

    public int hashCode() {
        int result = this.statusLine != null ? this.statusLine.hashCode() : 0;
        result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        return result;
    }
}

