/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.codehaus.httpcache4j.Directive;
import org.codehaus.httpcache4j.NameValue;
import org.codehaus.httpcache4j.util.Streamable;

public final class Directives
implements Streamable<Directive>,
Serializable {
    private final Map<String, Directive> directives;

    public Directives(Iterable<Directive> directives) {
        Map m = StreamSupport.stream(directives.spliterator(), false).collect(Collectors.toMap(NameValue::getName, Function.identity(), Directives.throwingMerger(), LinkedHashMap::new));
        this.directives = Collections.unmodifiableMap(m);
    }

    public Directives() {
        this.directives = Collections.emptyMap();
    }

    public boolean hasDirective(String key) {
        return this.directives.containsKey(key);
    }

    public String get(String key) {
        Directive directive = this.directives.get(key);
        if (directive == null) {
            return "";
        }
        return directive.getValue();
    }

    public Directive getAsDirective(String key) {
        return this.directives.get(key);
    }

    public int size() {
        return this.directives.size();
    }

    @Override
    public Iterator<Directive> iterator() {
        return new ArrayList<Directive>(this.directives.values()).iterator();
    }

    public String toString() {
        return this.stream().map(Directive::toString).collect(Collectors.joining(", "));
    }

    public Directives add(Directive directive) {
        List<Directive> list = Stream.concat(this.stream(), Arrays.asList(directive).stream()).collect(Collectors.toList());
        return new Directives(list);
    }

    private static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }
}

