/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.util.Locale;
import java.util.Objects;

public abstract class NameValue {
    protected final String name;
    protected final String value;

    protected NameValue(String name, String value) {
        Objects.requireNonNull(Boolean.valueOf(name != null), "You may not have an null name in a name value combination");
        if (value == null || value.trim().isEmpty()) {
            value = "";
        }
        this.value = value;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NameValue header = (NameValue)o;
        if (this.name != null ? !this.name.equalsIgnoreCase(header.name) : header.name != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(header.value) : header.value != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.toLowerCase(Locale.ENGLISH).hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "name: " + this.name + " value: " + this.value;
    }
}

