/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.util.Locale;
import org.codehaus.httpcache4j.Directives;
import org.codehaus.httpcache4j.HeaderConstants;
import org.codehaus.httpcache4j.NameValue;
import org.codehaus.httpcache4j.util.AuthDirectivesParser;
import org.codehaus.httpcache4j.util.DirectivesParser;
import org.codehaus.httpcache4j.util.Preconditions;

public final class Header
extends NameValue {
    private Directives directives;

    public Header(String name, String value) {
        super(name, value);
        Preconditions.checkArgument(name != null && !name.trim().isEmpty(), "You may not have an empty name in a header");
    }

    public Header(String name, Directives directives) {
        super(name, directives.toString());
        this.directives = directives;
    }

    @Override
    public final String toString() {
        return this.getName() + ": " + this.getValue();
    }

    public Directives getDirectives() {
        if (this.directives == null) {
            this.directives = HeaderConstants.AUTHENTICATION_HEADERS.contains(this.getName().toLowerCase(Locale.ENGLISH)) ? AuthDirectivesParser.parse(this.value) : DirectivesParser.parse(this.value);
        }
        return this.directives;
    }

    static Header valueOf(String value) {
        String[] parts = value.split(":", 2);
        if (parts != null) {
            if (parts.length == 1) {
                return new Header(parts[0].trim(), "");
            }
            if (parts.length == 2) {
                return new Header(parts[0].trim(), parts[1].trim());
            }
        }
        throw new IllegalArgumentException("Not a valid header string");
    }
}

