/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Tag;
import org.codehaus.httpcache4j.util.OptionalUtils;
import org.codehaus.httpcache4j.util.Preconditions;

public final class Conditionals {
    private final List<Tag> match;
    private final List<Tag> noneMatch;
    private final Optional<LocalDateTime> modifiedSince;
    private final Optional<LocalDateTime> unModifiedSince;
    private static final String ERROR_MESSAGE = "The combination of %s and %s is undefined by the HTTP specification";

    public Conditionals() {
        this(Conditionals.empty(), Conditionals.empty(), Optional.empty(), Optional.empty());
    }

    private static List<Tag> empty() {
        return Collections.emptyList();
    }

    public Conditionals(List<Tag> match, List<Tag> noneMatch, Optional<LocalDateTime> modifiedSince, Optional<LocalDateTime> unModifiedSince) {
        this.match = match;
        this.noneMatch = noneMatch;
        this.modifiedSince = modifiedSince;
        this.unModifiedSince = unModifiedSince;
    }

    public Conditionals addIfMatch(Tag tag) {
        Preconditions.checkArgument(!this.modifiedSince.isPresent(), String.format(ERROR_MESSAGE, "If-Match", "If-Modified-Since"));
        Preconditions.checkArgument(this.noneMatch.isEmpty(), String.format(ERROR_MESSAGE, "If-Match", "If-None-Match"));
        ArrayList<Tag> match = new ArrayList<Tag>(this.match);
        if (tag == null) {
            tag = Tag.ALL;
        }
        if (Tag.ALL.equals(tag)) {
            match.clear();
        }
        if (!match.contains(Tag.ALL)) {
            if (!match.contains(tag)) {
                match.add(tag);
            }
        } else {
            throw new IllegalArgumentException("Tag ALL already in the list");
        }
        return new Conditionals(Collections.unmodifiableList(match), Conditionals.empty(), Optional.empty(), this.unModifiedSince);
    }

    public Conditionals addIfNoneMatch(Tag tag) {
        Preconditions.checkArgument(!this.unModifiedSince.isPresent(), String.format(ERROR_MESSAGE, "If-None-Match", "If-Unmodified-Since"));
        Preconditions.checkArgument(this.match.isEmpty(), String.format(ERROR_MESSAGE, "If-None-Match", "If-Match"));
        ArrayList<Tag> noneMatch = new ArrayList<Tag>(this.noneMatch);
        if (tag == null) {
            tag = Tag.ALL;
        }
        if (Tag.ALL.equals(tag)) {
            noneMatch.clear();
        }
        if (!noneMatch.contains(Tag.ALL)) {
            if (!noneMatch.contains(tag)) {
                noneMatch.add(tag);
            }
        } else {
            throw new IllegalArgumentException("Tag ALL already in the list");
        }
        return new Conditionals(Conditionals.empty(), Collections.unmodifiableList(noneMatch), this.modifiedSince, Optional.empty());
    }

    public Conditionals ifModifiedSince(LocalDateTime time) {
        Preconditions.checkArgument(this.match.isEmpty(), String.format(ERROR_MESSAGE, "If-Modified-Since", "If-Match"));
        Preconditions.checkArgument(!this.unModifiedSince.isPresent(), String.format(ERROR_MESSAGE, "If-Modified-Since", "If-Unmodified-Since"));
        time = time.withNano(0);
        return new Conditionals(Conditionals.empty(), this.noneMatch, Optional.of(time), Optional.empty());
    }

    public Conditionals ifUnModifiedSince(LocalDateTime time) {
        Preconditions.checkArgument(this.noneMatch.isEmpty(), String.format(ERROR_MESSAGE, "If-Unmodified-Since", "If-None-Match"));
        Preconditions.checkArgument(!this.modifiedSince.isPresent(), String.format(ERROR_MESSAGE, "If-Unmodified-Since", "If-Modified-Since"));
        time = time.withNano(0);
        return new Conditionals(this.match, Conditionals.empty(), Optional.empty(), Optional.of(time));
    }

    public List<Tag> getMatch() {
        return Collections.unmodifiableList(this.match);
    }

    public List<Tag> getNoneMatch() {
        return Collections.unmodifiableList(this.noneMatch);
    }

    public Optional<LocalDateTime> getModifiedSince() {
        return this.modifiedSince;
    }

    public Optional<LocalDateTime> getUnModifiedSince() {
        return this.unModifiedSince;
    }

    public boolean isUnconditional() {
        return this.noneMatch.contains(Tag.ALL) || this.match.contains(Tag.ALL) || this.match.isEmpty() && !this.unModifiedSince.isPresent() || this.noneMatch.isEmpty() && !this.modifiedSince.isPresent();
    }

    public Headers toHeaders() {
        Headers headers = new Headers();
        if (!this.getMatch().isEmpty()) {
            headers = headers.add(new Header("If-Match", this.buildTagHeaderValue(this.getMatch())));
        }
        if (!this.getNoneMatch().isEmpty()) {
            headers = headers.add(new Header("If-None-Match", this.buildTagHeaderValue(this.getNoneMatch())));
        }
        if (this.modifiedSince.isPresent()) {
            headers = headers.set(HeaderUtils.toHttpDate("If-Modified-Since", this.modifiedSince.get()));
        }
        if (this.unModifiedSince.isPresent()) {
            headers = headers.set(HeaderUtils.toHttpDate("If-Unmodified-Since", this.unModifiedSince.get()));
        }
        return headers;
    }

    public static Conditionals valueOf(Headers headers) {
        List<Tag> ifMatch = Conditionals.makeTags(headers.getFirstHeaderValue("If-Match").orElse(null));
        List<Tag> ifNoneMatch = Conditionals.makeTags(headers.getFirstHeaderValue("If-None-Match").orElse(null));
        Optional<LocalDateTime> modifiedSince = headers.getFirstHeader("If-Modified-Since").flatMap(HeaderUtils::fromHttpDate);
        Optional<LocalDateTime> unModifiedSince = headers.getFirstHeader("If-Unmodified-Since").flatMap(HeaderUtils::fromHttpDate);
        return new Conditionals(ifMatch, ifNoneMatch, modifiedSince, unModifiedSince);
    }

    private static List<Tag> makeTags(String ifMatch) {
        if (ifMatch == null) {
            return Arrays.asList(new Tag[0]);
        }
        return Collections.unmodifiableList(Arrays.asList(ifMatch.split(",")).stream().filter(m -> !Objects.toString(m, "").isEmpty()).map(String::trim).flatMap(t -> OptionalUtils.stream(Tag.parse(t))).collect(Collectors.toList()));
    }

    private String buildTagHeaderValue(List<Tag> match) {
        return match.stream().map(Tag::format).collect(Collectors.joining(","));
    }
}

