/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.mutable;

import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.codehaus.httpcache4j.CacheControl;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Tag;
import org.codehaus.httpcache4j.preference.Preference;

public class MutableHeaders
implements Iterable<Header> {
    private Headers headers;

    public MutableHeaders() {
        this(new Headers());
    }

    MutableHeaders(Headers headers) {
        this.headers = Objects.requireNonNull(headers, "Headers may not be null");
    }

    public void add(Header header) {
        this.headers = this.headers.add(header);
    }

    public void add(String key, String value) {
        this.headers = this.headers.add(key, value);
    }

    public void add(String key, Iterable<String> values) {
        this.headers = this.headers.add(key, values);
    }

    public void add(Iterable<Header> headers) {
        this.headers = this.headers.add(headers);
    }

    public void set(Header header) {
        this.headers = this.headers.set(header);
    }

    public void set(String name, String value) {
        this.headers = this.headers.set(name, value);
    }

    public void set(Iterable<Header> headers) {
        this.headers = this.headers.set(headers);
    }

    public List<Header> getHeaders(String headerKey) {
        return this.headers.getHeaders(headerKey);
    }

    public Header getFirstHeader(String headerKey) {
        return this.headers.getFirstHeader(headerKey).orElse(null);
    }

    public String getFirstHeaderValue(String headerKey) {
        return this.headers.getFirstHeaderValue(headerKey).orElse(null);
    }

    public void addAcceptLanguage(Preference ... accept) {
        this.headers = this.headers.addAcceptLanguage(accept);
    }

    public List<Preference> getAcceptLanguage() {
        return this.headers.getAcceptLanguage();
    }

    public void setAcceptCharset(List<Preference> charsets) {
        this.headers = this.headers.withAcceptCharset(charsets);
    }

    public List<Preference> getAcceptCharset() {
        return this.headers.getAcceptCharset();
    }

    public void setExpires(LocalDateTime expires) {
        this.headers = this.headers.withExpires(expires);
    }

    public void addAccept(Preference ... accept) {
        this.headers = this.headers.addAccept(accept);
    }

    public LocalDateTime getLastModified() {
        return this.headers.getLastModified().orElse(null);
    }

    public void addAcceptCharset(Preference ... accept) {
        this.headers = this.headers.addAcceptCharset(accept);
    }

    public void setAccept(List<Preference> charsets) {
        this.headers = this.headers.withAccept(charsets);
    }

    public List<Preference> getAccept() {
        return this.headers.getAccept();
    }

    public void setAcceptLanguage(List<Preference> acceptLanguage) {
        this.headers = this.headers.withAcceptLanguage(acceptLanguage);
    }

    public void setLastModified(LocalDateTime lm) {
        this.headers = this.headers.withLastModified(lm);
    }

    public LocalDateTime getExpires() {
        return this.headers.getExpires().orElse(null);
    }

    public LocalDateTime getDate() {
        return this.headers.getDate().orElse(null);
    }

    public void setDate(LocalDateTime dt) {
        this.headers = this.headers.withDate(dt);
    }

    public Set<HTTPMethod> getAllow() {
        return this.headers.getAllow();
    }

    public void setAllow(Set<HTTPMethod> allow) {
        this.headers = this.headers.withAllow(allow);
    }

    public CacheControl getCacheControl() {
        return this.headers.getCacheControl().orElse(null);
    }

    public void setCacheControl(CacheControl cc) {
        this.headers = this.headers.withCacheControl(cc);
    }

    public Tag getETag() {
        return this.headers.getETag().orElse(null);
    }

    public void setETag(Tag tag) {
        this.headers = this.headers.withETag(tag);
    }

    public boolean contains(Header header) {
        return this.headers.contains(header);
    }

    public boolean contains(String headerName) {
        return this.headers.contains(headerName);
    }

    @Deprecated
    public boolean hasHeader(String headerName) {
        return this.headers.contains(headerName);
    }

    public int size() {
        return this.headers.size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public String toString() {
        return this.headers.toString();
    }

    public Headers toHeaders() {
        return this.headers;
    }

    public Set<String> keySet() {
        return this.headers.keySet();
    }

    @Override
    public Iterator<Header> iterator() {
        return this.headers.iterator();
    }
}

