/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.mutable;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.codehaus.httpcache4j.CacheControl;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.Tag;
import org.codehaus.httpcache4j.preference.Charset;
import org.codehaus.httpcache4j.preference.Preference;
import org.joda.time.DateTime;

public class MutableHeaders
implements Iterable<Header> {
    private Headers headers;

    public MutableHeaders() {
        this(new Headers());
    }

    MutableHeaders(Headers headers) {
        this.headers = (Headers)Preconditions.checkNotNull((Object)headers, (Object)"Headers may not be null");
    }

    public void add(Header header) {
        this.headers = this.headers.add(header);
    }

    public void add(String key, String value) {
        this.headers = this.headers.add(key, value);
    }

    public void add(String key, Iterable<String> values) {
        this.headers = this.headers.add(key, values);
    }

    public void add(Iterable<Header> headers) {
        this.headers = this.headers.add(headers);
    }

    public void set(Header header) {
        this.headers = this.headers.set(header);
    }

    public void set(String name, String value) {
        this.headers = this.headers.set(name, value);
    }

    public void set(Iterable<Header> headers) {
        this.headers = this.headers.set(headers);
    }

    public List<Header> getHeaders(String headerKey) {
        return this.headers.getHeaders(headerKey);
    }

    public Header getFirstHeader(String headerKey) {
        return this.headers.getFirstHeader(headerKey);
    }

    public String getFirstHeaderValue(String headerKey) {
        return this.headers.getFirstHeaderValue(headerKey);
    }

    public void addAcceptLanguage(Preference<Locale> ... accept) {
        this.headers = this.headers.addAcceptLanguage(accept);
    }

    public List<Preference<Locale>> getAcceptLanguage() {
        return this.headers.getAcceptLanguage();
    }

    public void setAcceptCharset(List<Preference<Charset>> charsets) {
        this.headers = this.headers.withAcceptCharset(charsets);
    }

    public List<Preference<Charset>> getAcceptCharset() {
        return this.headers.getAcceptCharset();
    }

    public void setExpires(DateTime expires) {
        this.headers = this.headers.withExpires(expires);
    }

    public void addAccept(Preference<MIMEType> ... accept) {
        this.headers = this.headers.addAccept(accept);
    }

    public DateTime getLastModified() {
        return this.headers.getLastModified();
    }

    public void addAcceptCharset(Preference<Charset> ... accept) {
        this.headers = this.headers.addAcceptCharset(accept);
    }

    public void setAccept(List<Preference<MIMEType>> charsets) {
        this.headers = this.headers.withAccept(charsets);
    }

    public List<Preference<MIMEType>> getAccept() {
        return this.headers.getAccept();
    }

    public void setAcceptLanguage(List<Preference<Locale>> acceptLanguage) {
        this.headers = this.headers.withAcceptLanguage(acceptLanguage);
    }

    public void setLastModified(DateTime lm) {
        this.headers = this.headers.withLastModified(lm);
    }

    public DateTime getExpires() {
        return this.headers.getExpires();
    }

    public DateTime getDate() {
        return this.headers.getDate();
    }

    public void setDate(DateTime dt) {
        this.headers = this.headers.withDate(dt);
    }

    public Set<HTTPMethod> getAllow() {
        return this.headers.getAllow();
    }

    public void setAllow(Set<HTTPMethod> allow) {
        this.headers = this.headers.withAllow(allow);
    }

    public CacheControl getCacheControl() {
        return this.headers.getCacheControl();
    }

    public void setCacheControl(CacheControl cc) {
        this.headers = this.headers.withCacheControl(cc);
    }

    public Tag getETag() {
        return this.headers.getETag();
    }

    public void setETag(Tag tag) {
        this.headers = this.headers.withETag(tag);
    }

    public boolean contains(Header header) {
        return this.headers.contains(header);
    }

    public boolean contains(String headerName) {
        return this.headers.contains(headerName);
    }

    @Deprecated
    public boolean hasHeader(String headerName) {
        return this.headers.contains(headerName);
    }

    public int size() {
        return this.headers.size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public String toString() {
        return this.headers.toString();
    }

    public Headers toHeaders() {
        return this.headers;
    }

    public Set<String> keySet() {
        return this.headers.keySet();
    }

    @Override
    public Iterator<Header> iterator() {
        return this.headers.iterator();
    }
}

