/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import com.google.common.io.ByteSource;
import com.google.common.io.FileBackedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import org.codehaus.httpcache4j.HTTPException;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.util.Digester;
import org.codehaus.httpcache4j.util.Hex;
import org.codehaus.httpcache4j.util.IOUtils;

public class MD5CaculcatingPayload
implements Payload {
    private final MIMEType mimeType;
    private final long length;
    private final String md5;
    private final ByteSource byteSource;

    private MD5CaculcatingPayload(InputStream stream, MIMEType mimeType, long length) {
        this.mimeType = mimeType;
        this.length = length;
        FileBackedOutputStream os = new FileBackedOutputStream(1024);
        try {
            DigestInputStream md5Stream = new DigestInputStream(stream, Digester.getDigest("MD5"));
            IOUtils.copy(md5Stream, (OutputStream)os);
            this.md5 = Hex.encode(md5Stream.getMessageDigest().digest());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.byteSource = os.asByteSource();
    }

    public String getMD5() {
        return this.md5;
    }

    @Override
    public MIMEType getMimeType() {
        return this.mimeType;
    }

    @Override
    public InputStream getInputStream() {
        try {
            return this.byteSource.openStream();
        }
        catch (IOException e) {
            throw new HTTPException(e);
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public static MD5CaculcatingPayload payloadFor(Payload p) {
        return new MD5CaculcatingPayload(p.getInputStream(), p.getMimeType(), p.length());
    }
}

