/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth.bearer;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public final class BearerToken {
    private String token;

    public BearerToken(String token) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)token) ? 1 : 0) != 0, (Object)"Token was null or empty");
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public String toHeaderValue() {
        return "Bearer " + this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BearerToken that = (BearerToken)o;
        return !(this.token != null ? !this.token.equals(that.token) : that.token != null);
    }

    public int hashCode() {
        return this.token != null ? this.token.hashCode() : 0;
    }
}

