/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.httpcache4j.Directive;
import org.codehaus.httpcache4j.HTTPHost;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.AuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.BasicAuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.DefaultSchemeRegistry;
import org.codehaus.httpcache4j.auth.DigestAuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.NullAuthenticatorStrategy;
import org.codehaus.httpcache4j.auth.SchemeRegistry;
import org.codehaus.httpcache4j.util.Pair;

class AuthenticatorBase {
    private static final Function<Directive, AuthScheme> AuthSchemeF = new Function<Directive, AuthScheme>(){

        public AuthScheme apply(Directive input) {
            return new AuthScheme(input);
        }
    };
    private final List<AuthenticatorStrategy> strategies = Lists.newArrayList();
    protected final SchemeRegistry registry = new DefaultSchemeRegistry();

    public AuthenticatorBase() {
        this(AuthenticatorBase.defaultStrategies());
    }

    public AuthenticatorBase(List<AuthenticatorStrategy> strategies) {
        this.strategies.addAll(strategies);
    }

    protected static List<AuthenticatorStrategy> defaultStrategies() {
        return ImmutableList.of((Object)new DigestAuthenticatorStrategy(), (Object)new BasicAuthenticatorStrategy());
    }

    protected Pair<AuthenticatorStrategy, AuthScheme> select(List<AuthScheme> authScheme) {
        AuthenticatorStrategy selected = null;
        AuthScheme selectedScheme = null;
        block0: for (AuthenticatorStrategy strategy : this.strategies) {
            for (AuthScheme scheme : authScheme) {
                if (!strategy.supports(scheme)) continue;
                selected = strategy;
                selectedScheme = scheme;
                continue block0;
            }
        }
        if (selected == null) {
            selected = new NullAuthenticatorStrategy();
        }
        return Pair.of(selected, selectedScheme);
    }

    public boolean canAuthenticatePreemptively(HTTPHost host) {
        return this.registry.matches(host);
    }

    protected List<AuthScheme> toAuthSchemes(HTTPResponse response, String name) {
        List<Header> authenticateHeader = response.getHeaders().getHeaders(name);
        ArrayList directives = new ArrayList();
        for (Header header : authenticateHeader) {
            Iterables.addAll(directives, (Iterable)header.getDirectives());
        }
        return Lists.transform(directives, AuthSchemeF);
    }
}

