/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import com.google.common.io.ByteStreams;
import com.google.common.io.FileBackedOutputStream;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.codehaus.httpcache4j.HTTPException;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.util.Hex;

public class MD5CaculcatingPayload
implements Payload {
    private final MIMEType mimeType;
    private final long length;
    private final String md5;
    private final InputSupplier<InputStream> supplier;

    private MD5CaculcatingPayload(InputStream stream, MIMEType mimeType, long length) {
        this.mimeType = mimeType;
        this.length = length;
        FileBackedOutputStream os = new FileBackedOutputStream(1024);
        try {
            DigestInputStream md5Stream = new DigestInputStream(stream, MessageDigest.getInstance("MD5"));
            ByteStreams.copy((InputStream)md5Stream, (OutputStream)os);
            this.md5 = Hex.encode(md5Stream.getMessageDigest().digest());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        this.supplier = os.getSupplier();
    }

    public String getMD5() {
        return this.md5;
    }

    @Override
    public MIMEType getMimeType() {
        return this.mimeType;
    }

    @Override
    public InputStream getInputStream() {
        try {
            return (InputStream)this.supplier.getInput();
        }
        catch (IOException e) {
            throw new HTTPException(e);
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    public static MD5CaculcatingPayload payloadFor(Payload p) {
        return new MD5CaculcatingPayload(p.getInputStream(), p.getMimeType(), p.length());
    }
}

