/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.Payload;

public class StringPayload
implements Payload {
    private final String value;
    private final MIMEType mimeType;
    private Charset charset;

    public StringPayload(String value, MIMEType mimeType) {
        this(value, mimeType, Charsets.UTF_8);
    }

    public StringPayload(String value, MIMEType mimeType, Charset charset) {
        this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"String value may not be null");
        this.mimeType = (MIMEType)Preconditions.checkNotNull((Object)mimeType, (Object)"MIMEType may not be null");
        this.charset = charset != null ? charset : Charsets.UTF_8;
    }

    @Override
    public MIMEType getMimeType() {
        return this.mimeType;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.value.getBytes(this.charset));
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public long length() {
        return this.value.length();
    }
}

