/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.net.URI;
import java.util.LinkedHashMap;
import org.codehaus.httpcache4j.LinkDirective;
import org.codehaus.httpcache4j.Parameter;
import org.codehaus.httpcache4j.QuotedParameter;

public class LinkDirectiveBuilder {
    private final LinkMap parameters = new LinkMap();
    private final URI uri;

    private LinkDirectiveBuilder(URI uri, LinkMap parameters) {
        this.uri = uri;
        this.parameters.putAll(parameters);
    }

    public LinkDirectiveBuilder uri(URI uri) {
        return new LinkDirectiveBuilder(uri, this.parameters);
    }

    public LinkDirectiveBuilder rel(String rel) {
        return this.parameter(new QuotedParameter("rel", rel));
    }

    public LinkDirectiveBuilder rev(String rev) {
        return this.parameter(new QuotedParameter("rev", rev));
    }

    public LinkDirectiveBuilder title(String title) {
        return this.parameter(new QuotedParameter("title", title));
    }

    public LinkDirectiveBuilder anchor(URI anchor) {
        return this.parameter(new QuotedParameter("anchor", anchor.toString()));
    }

    public LinkDirectiveBuilder parameter(Parameter parameter) {
        return new LinkDirectiveBuilder(this.uri, new LinkMap(this.parameters, parameter));
    }

    public LinkDirective build() {
        return new LinkDirective(this.uri, this.parameters.values());
    }

    public static LinkDirectiveBuilder create(URI uri) {
        return new LinkDirectiveBuilder(uri, new LinkMap());
    }

    private static class LinkMap
    extends LinkedHashMap<String, Parameter> {
        public LinkMap() {
        }

        public LinkMap(LinkMap m, Parameter directive) {
            super(m);
            this.put(directive.getName(), directive);
        }
    }
}

