/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.httpcache4j.Header;

public abstract class CacheHeaderBuilder {
    private static final AtomicReference<CacheHeaderBuilder> INSTANCE = new AtomicReference<LocalHostCacheHeaderBuilder>(new LocalHostCacheHeaderBuilder());

    public abstract Header createMISSXCacheHeader();

    public abstract Header createHITXCacheHeader();

    public static void setBuilder(CacheHeaderBuilder builder) {
        INSTANCE.set(builder);
    }

    public static CacheHeaderBuilder getBuilder() {
        return INSTANCE.get();
    }

    private static class LocalHostCacheHeaderBuilder
    extends CacheHeaderBuilder {
        private static final String X_CACHE_FORMAT = "%s from HTTPCache4j(%s)";

        private LocalHostCacheHeaderBuilder() {
        }

        private String getHostAddress() {
            String hostname;
            try {
                hostname = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException ex) {
                hostname = "localhost";
            }
            return hostname;
        }

        @Override
        public Header createMISSXCacheHeader() {
            String value = String.format(X_CACHE_FORMAT, "MISS", this.getHostAddress());
            return new Header("X-Cache", value);
        }

        @Override
        public Header createHITXCacheHeader() {
            String value = String.format(X_CACHE_FORMAT, "HIT", this.getHostAddress());
            return new Header("X-Cache", value);
        }
    }
}

