/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.MimeType;
import javax.activation.MimeTypeParameterList;
import javax.activation.MimeTypeParseException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.codehaus.httpcache4j.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MIMEType {
    public static final MIMEType ALL = new MIMEType("*", "*");
    public static final MIMEType APPLICATION_OCTET_STREAM = new MIMEType("application", "octet-stream");
    private final MimeType mimeType;

    public MIMEType(String MIMEType2) {
        MimeType mimeType;
        try {
            mimeType = new MimeType(MIMEType2);
        }
        catch (MimeTypeParseException e) {
            throw new IllegalArgumentException(e);
        }
        this.mimeType = mimeType;
    }

    public MIMEType(String primaryType, String subType) {
        MimeType mimeType;
        try {
            mimeType = new MimeType(primaryType, subType);
        }
        catch (MimeTypeParseException e) {
            throw new IllegalArgumentException(e);
        }
        this.mimeType = mimeType;
    }

    public void addParameter(String name, String value) {
        this.mimeType.setParameter(name, value);
    }

    public String getSubType() {
        return this.mimeType.getSubType();
    }

    public String getPrimaryType() {
        return this.mimeType.getPrimaryType();
    }

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object o, boolean includeParameters) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MIMEType other = (MIMEType)o;
        if (!new EqualsBuilder().append((Object)this.getPrimaryType(), (Object)other.getPrimaryType()).append((Object)this.getSubType(), (Object)other.getSubType()).isEquals()) {
            return false;
        }
        return !includeParameters || this.parametersEquals(other);
    }

    private boolean parametersEquals(MIMEType other) {
        Map<String, String> otherParameterList = this.convertParams(other.mimeType.getParameters());
        Map<String, String> parameterList = this.convertParams(this.mimeType.getParameters());
        return ((Object)parameterList).equals(otherParameterList);
    }

    public int hashCode() {
        return new HashCodeBuilder(11, 31).append((Object)this.getPrimaryType()).append((Object)this.getSubType()).toHashCode();
    }

    public boolean includes(MIMEType mimeType) {
        boolean includes;
        boolean bl = includes = mimeType == null || this.equals(ALL, false) || this.equals(mimeType, false);
        if (!includes) {
            includes = this.getPrimaryType().equals(mimeType.getPrimaryType()) && (this.getSubType().equals(mimeType.getSubType()) || this.getSubType().equals("*"));
        }
        return includes;
    }

    public List<Parameter> getParameters() {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        Map<String, String> map = this.convertParams(this.mimeType.getParameters());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            list.add(new Parameter(entry.getKey(), entry.getValue()));
        }
        return Collections.unmodifiableList(list);
    }

    public String toString() {
        return this.mimeType.toString();
    }

    private Map<String, String> convertParams(MimeTypeParameterList list) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration names = list.getNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            map.put(name, list.get(name));
        }
        return map;
    }

    public static MIMEType valueOf(String MIMEType2) {
        return new MIMEType(MIMEType2);
    }

    public static MIMEType valueOf(String primaryType, String subType) {
        return new MIMEType(primaryType, subType);
    }
}

