/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth;

import java.util.List;
import org.codehaus.httpcache4j.HTTPHost;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.Authenticator;
import org.codehaus.httpcache4j.auth.AuthenticatorBase;
import org.codehaus.httpcache4j.auth.AuthenticatorStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthenticator
extends AuthenticatorBase
implements Authenticator {
    public DefaultAuthenticator() {
    }

    public DefaultAuthenticator(List<AuthenticatorStrategy> strategies) {
        super(strategies);
    }

    @Override
    public final HTTPRequest prepareAuthentication(HTTPRequest request, HTTPResponse response) {
        AuthScheme scheme;
        Header authenticateHeader;
        HTTPRequest req = request;
        HTTPHost host = new HTTPHost(request.getRequestURI());
        if (response == null && this.registry.matches(host)) {
            AuthScheme authScheme = this.registry.get(host);
            AuthenticatorStrategy selected = this.select(authScheme);
            return selected.prepare(request, authScheme);
        }
        if (response != null && response.getStatus() == Status.UNAUTHORIZED && (authenticateHeader = response.getHeaders().getFirstHeader("WWW-Authenticate")) != null && request.getChallenge() != null && (req = this.select(scheme = new AuthScheme(authenticateHeader)).prepare(request, scheme)) != request) {
            this.registry.register(host, scheme);
        }
        return req;
    }

    @Override
    public boolean canAuthenticatePreemptively(HTTPRequest request) {
        return this.canAuthenticatePreemptively(new HTTPHost(request.getRequestURI()));
    }

    @Override
    public HTTPRequest preparePreemptiveAuthentication(HTTPRequest request) {
        return this.prepareAuthentication(request, null);
    }

    @Override
    public void afterSuccessfulAuthentication(HTTPRequest request, Headers responseHeaders) {
        AuthScheme scheme;
        AuthScheme updatedScheme;
        HTTPHost host = new HTTPHost(request.getRequestURI());
        if (this.registry.matches(host) && (updatedScheme = this.select(scheme = this.registry.get(host)).afterSuccessfulAuthentication(scheme, responseHeaders)) != scheme) {
            this.registry.register(host, updatedScheme);
        }
    }

    @Override
    public void afterFailedAuthentication(HTTPRequest request, Headers responseHeaders) {
        HTTPHost host = new HTTPHost(request.getRequestURI());
        this.registry.remove(host);
    }
}

