/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.util.CaseInsensitiveKey;

public final class HTTPMethod {
    public static final HTTPMethod CONNECT = new HTTPMethod("CONNECT");
    public static final HTTPMethod DELETE = new HTTPMethod("DELETE");
    public static final HTTPMethod GET = new HTTPMethod("GET");
    public static final HTTPMethod HEAD = new HTTPMethod("HEAD");
    public static final HTTPMethod OPTIONS = new HTTPMethod("OPTIONS");
    public static final HTTPMethod PATCH = new HTTPMethod("PATCH");
    public static final HTTPMethod POST = new HTTPMethod("POST");
    public static final HTTPMethod PURGE = new HTTPMethod("PURGE");
    public static final HTTPMethod PUT = new HTTPMethod("PUT");
    public static final HTTPMethod TRACE = new HTTPMethod("TRACE");
    private static Map<CaseInsensitiveKey, HTTPMethod> defaultMethods = ImmutableMap.builder().put((Object)new CaseInsensitiveKey(CONNECT.getMethod()), (Object)CONNECT).put((Object)new CaseInsensitiveKey(DELETE.getMethod()), (Object)DELETE).put((Object)new CaseInsensitiveKey(GET.getMethod()), (Object)GET).put((Object)new CaseInsensitiveKey(HEAD.getMethod()), (Object)HEAD).put((Object)new CaseInsensitiveKey(OPTIONS.getMethod()), (Object)OPTIONS).put((Object)new CaseInsensitiveKey(PATCH.getMethod()), (Object)PATCH).put((Object)new CaseInsensitiveKey(POST.getMethod()), (Object)POST).put((Object)new CaseInsensitiveKey(PURGE.getMethod()), (Object)PURGE).put((Object)new CaseInsensitiveKey(PUT.getMethod()), (Object)PUT).put((Object)new CaseInsensitiveKey(TRACE.getMethod()), (Object)TRACE).build();
    private final String method;

    private HTTPMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    @Deprecated
    public String name() {
        return this.getMethod();
    }

    public String toString() {
        return this.method;
    }

    public static HTTPMethod[] values() {
        return defaultMethods.values().toArray(new HTTPMethod[defaultMethods.size()]);
    }

    public static HTTPMethod valueOf(String method) {
        Validate.notEmpty((String)method, (String)"Method name may not be null or empty");
        CaseInsensitiveKey key = new CaseInsensitiveKey(method);
        if (defaultMethods.containsKey(key)) {
            return defaultMethods.get(key);
        }
        return new HTTPMethod(method.toUpperCase(Locale.ENGLISH));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPMethod that = (HTTPMethod)o;
        return !(this.method != null ? !this.method.equalsIgnoreCase(that.method) : that.method != null);
    }

    public int hashCode() {
        return this.method != null ? this.method.hashCode() : 0;
    }

    public boolean canHavePayload() {
        return this == POST || this == PUT || this == PATCH;
    }
}

