/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth.digest;

import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.httpcache4j.Directives;
import org.codehaus.httpcache4j.HTTPHost;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.digest.Algorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Digest {
    private final HTTPHost host;
    private final String nonce;
    private final List<URI> domain;
    private final String opaque;
    private final boolean stale;
    private final Algorithm algorithm;
    private final String qop;
    private final AuthScheme scheme;

    public Digest(HTTPHost host, AuthScheme scheme) {
        this.scheme = scheme;
        Directives directives = scheme.getDirectives();
        this.host = host;
        this.nonce = directives.get("nonce");
        this.domain = this.parseDomain(directives.get("domain"));
        this.opaque = directives.get("opaque");
        this.stale = BooleanUtils.toBoolean((String)directives.get("stale"));
        this.algorithm = Algorithm.getAlgorithm(directives.get("algorithm"));
        this.qop = directives.get("qop");
    }

    private List<URI> parseDomain(String domain) {
        String[] strings;
        if (StringUtils.isNotBlank((String)domain) && !"*".equals(domain) && (strings = domain.split(" ")).length > 0) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (String string : strings) {
                URI uri;
                if (string.startsWith("/")) {
                    string = this.host.toURI().resolve(string).toString();
                }
                if (!(uri = URI.create(string)).isAbsolute() && uri.getHost() == null) {
                    uri = this.host.toURI().resolve(uri);
                }
                builder.add((Object)uri);
            }
            return builder.build();
        }
        return Collections.emptyList();
    }

    public String getNonce() {
        return this.nonce;
    }

    public List<URI> getDomain() {
        return this.domain;
    }

    public String getOpaque() {
        return this.opaque;
    }

    public boolean isStale() {
        return this.stale;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public String getQop() {
        return this.qop;
    }

    public AuthScheme getScheme() {
        return this.scheme;
    }

    public HTTPHost getHost() {
        return this.host;
    }

    public String toString() {
        return "Digest{host=" + this.host + ", nonce='" + this.nonce + '\'' + ", domain=" + this.domain + ", opaque='" + this.opaque + '\'' + ", stale=" + this.stale + ", algorithm=" + (Object)((Object)this.algorithm) + ", qop='" + this.qop + '\'' + '}';
    }
}

