/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth;

import java.nio.charset.Charset;
import org.apache.commons.codec.binary.Base64;
import org.codehaus.httpcache4j.Challenge;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.UsernamePasswordChallenge;
import org.codehaus.httpcache4j.auth.AuthScheme;
import org.codehaus.httpcache4j.auth.AuthenticatorStrategy;

public class BasicAuthenticatorStrategy
implements AuthenticatorStrategy {
    private final Charset UTF_8 = Charset.forName("UTF-8");

    public boolean supports(AuthScheme scheme) {
        return "basic".equalsIgnoreCase(scheme.getType());
    }

    public HTTPRequest prepare(HTTPRequest request, AuthScheme scheme) {
        return this.prepare(request, request.getChallenge(), false);
    }

    public HTTPRequest prepareWithProxy(HTTPRequest request, Challenge challenge, AuthScheme scheme) {
        return this.prepare(request, challenge, true);
    }

    private HTTPRequest prepare(HTTPRequest request, Challenge challenge, boolean proxy) {
        HTTPRequest req = request;
        if (challenge instanceof UsernamePasswordChallenge) {
            UsernamePasswordChallenge upc = (UsernamePasswordChallenge)challenge;
            String basicString = upc.getIdentifier() + ":" + new String(upc.getPassword());
            String authValue = "Basic " + new String(Base64.encodeBase64((byte[])basicString.getBytes()));
            req = proxy ? request.addHeader("Proxy-Authorization", authValue) : request.addHeader("Authorization", authValue);
        }
        return req;
    }

    public AuthScheme afterSuccessfulAuthentication(AuthScheme scheme, Headers headers) {
        return scheme;
    }

    public AuthScheme afterSuccessfulProxyAuthentication(AuthScheme scheme, Headers headers) {
        return scheme;
    }
}

