/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.atomic.AtomicReference;
import org.codehaus.httpcache4j.Header;

public abstract class CacheHeaderBuilder {
    private static final AtomicReference<CacheHeaderBuilder> INSTANCE = new AtomicReference<LocalHostCacheHeaderBuilder>(new LocalHostCacheHeaderBuilder());

    public abstract Header createMISSXCacheHeader();

    public abstract Header createHITXCacheHeader();

    public static void setBuilder(CacheHeaderBuilder builder) {
        INSTANCE.set(builder);
    }

    public static CacheHeaderBuilder getBuilder() {
        return INSTANCE.get();
    }

    private static class LocalHostCacheHeaderBuilder
    extends CacheHeaderBuilder {
        private static final String X_CACHE_FORMAT = "%s from HTTPCache4j(%s)";

        private LocalHostCacheHeaderBuilder() {
        }

        private String getCanonicalHostName() {
            String canonicalHostName;
            try {
                canonicalHostName = InetAddress.getLocalHost().getCanonicalHostName();
            }
            catch (UnknownHostException ex) {
                canonicalHostName = "localhost";
            }
            return canonicalHostName;
        }

        public Header createMISSXCacheHeader() {
            String value = String.format(X_CACHE_FORMAT, "MISS", this.getCanonicalHostName());
            return new Header("X-Cache", value);
        }

        public Header createHITXCacheHeader() {
            String value = String.format(X_CACHE_FORMAT, "HIT", this.getCanonicalHostName());
            return new Header("X-Cache", value);
        }
    }
}

