/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import org.apache.commons.lang.math.NumberUtils;
import org.codehaus.httpcache4j.Directives;
import org.codehaus.httpcache4j.Header;

public class CacheControl {
    private final Directives directives;

    public CacheControl(String value) {
        this(new Directives(value));
    }

    public CacheControl(Header header) {
        if (!"Cache-Control".equalsIgnoreCase(header.getName())) {
            throw new IllegalArgumentException("Not a Cache-Control header");
        }
        this.directives = header.getDirectives();
    }

    public CacheControl(Directives directives) {
        this.directives = directives;
    }

    public boolean isPrivate() {
        return this.directives.hasDirective("private");
    }

    public int getMaxAge() {
        return NumberUtils.toInt((String)this.directives.get("max-age"), (int)-1);
    }

    public int getSMaxAge() {
        return NumberUtils.toInt((String)this.directives.get("s-maxage"), (int)-1);
    }

    public boolean isPublic() {
        return this.directives.hasDirective("public");
    }

    public int getMaxStale() {
        return NumberUtils.toInt((String)this.directives.get("max-stale"), (int)-1);
    }

    public int getMinFresh() {
        return NumberUtils.toInt((String)this.directives.get("min-fresh"), (int)-1);
    }

    public boolean isNoTransform() {
        return this.directives.hasDirective("no-transform");
    }

    public boolean isMustRevalidate() {
        return this.directives.hasDirective("must-revalidate");
    }

    public boolean isProxyRevalidate() {
        return this.directives.hasDirective("proxy-revalidate");
    }

    public boolean isNoStore() {
        return this.directives.hasDirective("no-store");
    }

    public boolean isNoCache() {
        return this.directives.hasDirective("no-cache");
    }

    public Directives getDirectives() {
        return this.directives;
    }

    public Header toHeader() {
        return new Header("Cache-Control", new Directives(this.directives));
    }
}

