/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.codehaus.httpcache4j.HTTPException;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.payload.Payload;

public class ResponseWriter {
    private final HTTPResponse response;

    public ResponseWriter(HTTPResponse response) {
        this.response = response;
    }

    public void write() {
        this.write(new PrintWriter(System.out));
    }

    public void write(Writer output) {
        PrintWriter writer = new PrintWriter(output);
        this.writeStatus(writer, this.response.getStatus());
        this.writeHeaders(writer, this.response.getHeaders());
        writer.println();
        if (this.response.hasPayload() && this.response.getPayload().isAvailable()) {
            this.writeBody(writer, this.response.getPayload());
        }
        writer.print("\r\n");
        writer.flush();
    }

    private void writeStatus(PrintWriter writer, Status status) {
        writer.println(String.format("HTTP/1.1 %s %s", status.getCode(), status.getName()));
    }

    private void writeHeaders(PrintWriter writer, Headers headers) {
        for (Header head : headers) {
            writer.println(head.toString());
        }
    }

    private void writeBody(PrintWriter writer, Payload payload) {
        InputStream stream = payload.getInputStream();
        try {
            IOUtils.copy((InputStream)stream, (Writer)writer);
        }
        catch (IOException e) {
            throw new HTTPException("Unable to write the body of the response", e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }
}

