/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.mutable;

import java.net.URI;
import org.codehaus.httpcache4j.Challenge;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.mutable.MutableConditionals;
import org.codehaus.httpcache4j.mutable.MutableHeaders;
import org.codehaus.httpcache4j.mutable.MutablePreferences;
import org.codehaus.httpcache4j.payload.Payload;
import org.joda.time.DateTime;

public class MutableRequest {
    private final URI uri;
    private final HTTPMethod method;
    private final MutableHeaders headers;
    private final MutableConditionals conditionals;
    private final MutablePreferences preferences;
    private Challenge challenge;
    private Payload payload;

    public MutableRequest(URI uri) {
        this(uri, HTTPMethod.GET);
    }

    public MutableRequest(URI uri, HTTPMethod method) {
        this(uri, method, new MutableHeaders(), new MutableConditionals(), new MutablePreferences());
    }

    private MutableRequest(URI uri, HTTPMethod method, MutableHeaders headers, MutableConditionals conditionals, MutablePreferences preferences) {
        this.uri = uri;
        this.method = method;
        this.headers = headers;
        this.conditionals = conditionals;
        this.preferences = preferences;
    }

    public URI getUri() {
        return this.uri;
    }

    public HTTPMethod getMethod() {
        return this.method;
    }

    public MutableHeaders getHeaders() {
        return this.headers;
    }

    public MutableConditionals getConditionals() {
        return this.conditionals;
    }

    public MutablePreferences getPreferences() {
        return this.preferences;
    }

    public Challenge getChallenge() {
        return this.challenge;
    }

    public void setChallenge(Challenge challenge) {
        this.challenge = challenge;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public void setPayload(Payload payload) {
        if (!this.method.canHavePayload()) {
            throw new IllegalStateException(String.format("Unable to add payload to a %s request", new Object[]{this.method}));
        }
        this.payload = payload;
    }

    public void addHeader(Header header) {
        this.headers.add(header);
    }

    public void addHeader(String name, String value) {
        this.addHeader(new Header(name, value));
    }

    public HTTPRequest toRequest() {
        return new FromMutableRequest();
    }

    public static MutableRequest fromHTTPRequest(HTTPRequest request) {
        MutableRequest mutableRequest = new MutableRequest(request.getRequestURI(), request.getMethod(), new MutableHeaders(request.getHeaders()), new MutableConditionals(request.getConditionals()), new MutablePreferences(request.getPreferences()));
        mutableRequest.setChallenge(request.getChallenge());
        if (request.getMethod().canHavePayload()) {
            mutableRequest.setPayload(request.getPayload());
        }
        return mutableRequest;
    }

    private class FromMutableRequest
    extends HTTPRequest {
        private FromMutableRequest() {
            super(MutableRequest.this.uri, MutableRequest.this.method, MutableRequest.this.headers.toHeaders(), MutableRequest.this.conditionals.toConditionals(), MutableRequest.this.preferences.toPreferences(), MutableRequest.this.challenge, MutableRequest.this.payload, new DateTime());
        }
    }
}

