/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.net.URI;

public class HTTPHost {
    private final String host;
    private final int port;

    public HTTPHost(String host, int port) {
        this.host = host;
        this.port = port == -1 ? 80 : port;
    }

    public HTTPHost(URI uri) {
        this(uri.getHost(), uri.getPort());
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPHost httpHost = (HTTPHost)o;
        if (this.port != httpHost.port) {
            return false;
        }
        return !(this.host != null ? !this.host.equals(httpHost.host) : httpHost.host != null);
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }
}

