/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Headers
implements Serializable,
Iterable<Header> {
    private static final long serialVersionUID = -7175564984758939316L;
    private final HeaderHashMap headers = new HeaderHashMap();

    public Headers() {
    }

    public Headers(Headers headers) {
        Validate.notNull((Object)headers, (String)"The headers may not be null");
        this.headers.putAll(headers.copyMap());
    }

    private Headers(HeaderHashMap headers) {
        Validate.notNull((Object)headers, (String)"The header map may not be null");
        this.headers.putAll(headers);
    }

    public List<Header> getHeaders(String headerKey) {
        return this.headers.getAsHeaders(headerKey);
    }

    public Header getFirstHeader(String headerKey) {
        List<Header> headerList = this.getHeaders(headerKey);
        if (!headerList.isEmpty()) {
            return headerList.get(0);
        }
        return null;
    }

    public String getFirstHeaderValue(String headerKey) {
        Header header = this.getFirstHeader(headerKey);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public Headers add(Header header) {
        HeaderHashMap headers = this.copyMap();
        ArrayList<String> list = new ArrayList<String>((Collection<String>)headers.get(header.getName()));
        if (!list.contains(header.getValue())) {
            list.add(header.getValue());
        }
        headers.put(header.getName(), (List<String>)list);
        return new Headers(headers);
    }

    public Headers add(String key, String value) {
        return this.add(new Header(key, value));
    }

    public boolean contains(Header header) {
        List<Header> values = this.getHeaders(header.getName());
        return values.contains(header);
    }

    private HeaderHashMap copyMap() {
        return new HeaderHashMap(this.headers);
    }

    @Override
    public Iterator<Header> iterator() {
        return this.headers.getAsHeaders();
    }

    public Set<String> keySet() {
        return this.headers.keySet();
    }

    public boolean hasHeader(String headerName) {
        return !this.headers.get(headerName).isEmpty();
    }

    public Headers add(String name, List<Header> headers) {
        HeaderHashMap heads = this.copyMap();
        heads.putImpl(name, headers);
        return new Headers(heads);
    }

    public Headers remove(String name) {
        HeaderHashMap heads = this.copyMap();
        heads.remove(name);
        return new Headers(heads);
    }

    public Headers add(Iterable<Header> headers) {
        HeaderHashMap map = this.copyMap();
        for (Header header : headers) {
            ArrayList<String> list = new ArrayList<String>((Collection<String>)map.get(header.getName()));
            if (!list.contains(header.getValue())) {
                list.add(header.getValue());
            }
            map.put(header.getName(), (List<String>)list);
        }
        return new Headers(map);
    }

    public int size() {
        return this.headers.size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Headers headers1 = (Headers)o;
        return this.headers.equals(headers1.headers);
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Header header : this) {
            if (builder.length() > 0) {
                builder.append("\r\n");
            }
            builder.append(header);
        }
        return builder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HeaderHashMap
    extends LinkedHashMap<String, List<String>> {
        private static final long serialVersionUID = 2714358409043444835L;
        private static final Function<Header, String> headerToString = new Function<Header, String>(){

            public String apply(Header from) {
                return from.getValue();
            }
        };

        public HeaderHashMap() {
        }

        public HeaderHashMap(HeaderHashMap headerHashMap) {
            super(headerHashMap);
        }

        @Override
        public List<String> get(Object key) {
            List<String> value = (List<String>)super.get(((String)key).toLowerCase());
            return value != null ? value : Collections.emptyList();
        }

        List<Header> getAsHeaders(String key) {
            ArrayList headers = new ArrayList();
            headers.addAll(Lists.transform((List)this.get(key), this.stringToHeader(key)));
            return Collections.unmodifiableList(headers);
        }

        private Function<String, Header> stringToHeader(final String key) {
            return new Function<String, Header>(){

                public Header apply(String from) {
                    return new Header(key, from);
                }
            };
        }

        @Override
        public List<String> put(String key, List<String> value) {
            return super.put(key.toLowerCase(), value);
        }

        List<String> putImpl(String key, List<Header> value) {
            List stringList = Lists.transform(value, headerToString);
            return this.put(key, (List<String>)new ArrayList<String>(stringList));
        }

        Iterator<Header> getAsHeaders() {
            ArrayList headers = new ArrayList();
            for (Map.Entry entry : this.entrySet()) {
                headers.addAll(Lists.transform((List)((List)entry.getValue()), this.stringToHeader((String)entry.getKey())));
            }
            return headers.iterator();
        }
    }
}

