/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.HTTPRequest;

public final class HTTPUtil {
    private HTTPUtil() {
    }

    public static boolean isCacheableRequest(HTTPRequest request) {
        if (request.getMethod() == HTTPMethod.GET || request.getMethod() == HTTPMethod.HEAD) {
            if (request.getHeaders().hasHeader("Cache-Control")) {
                String cacheControlHeaderValue = request.getHeaders().getFirstHeader("Cache-Control").getValue();
                return !cacheControlHeaderValue.contains("no-store") || !cacheControlHeaderValue.contains("no-cache");
            }
            return true;
        }
        return false;
    }
}

