/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import org.codehaus.httpcache4j.Metadata;

public final class Tag
extends Metadata {
    private static final long serialVersionUID = 673213161743597801L;
    public static final Tag ALL = Tag.parse("*");
    private boolean weak;

    public static Tag parse(String httpTag) {
        Tag result = null;
        boolean weak = false;
        String httpTagCopy = httpTag;
        if (httpTagCopy.startsWith("W/")) {
            weak = true;
            httpTagCopy = httpTagCopy.substring(2);
        }
        if (httpTagCopy.startsWith("\"") && httpTagCopy.endsWith("\"")) {
            result = new Tag(httpTagCopy.substring(1, httpTagCopy.length() - 1), weak);
        } else if (httpTagCopy.equals("*")) {
            result = new Tag("*", weak);
        }
        return result;
    }

    public Tag(String opaqueTag, boolean weak) {
        super(opaqueTag);
        this.weak = weak;
    }

    public Tag(String opaqueTag) {
        this(opaqueTag, false);
    }

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean checkWeakness) {
        boolean result;
        boolean bl = result = object != null && object instanceof Tag;
        if (result) {
            Tag that = (Tag)object;
            if (checkWeakness) {
                boolean bl2 = result = that.isWeak() == this.isWeak();
            }
            if (result) {
                result = this.getName() == null ? that.getName() == null : this.getName().equals(that.getName());
            }
        }
        return result;
    }

    public String format() {
        if (this.getName().equals("*")) {
            return "*";
        }
        StringBuilder sb = new StringBuilder();
        if (this.isWeak()) {
            sb.append("W/");
        }
        return sb.append('\"').append(this.getName()).append('\"').toString();
    }

    public String getDescription() {
        return "HTTP entity tag";
    }

    public String getName() {
        return super.getName();
    }

    public String toString() {
        return "opaque tag: " + this.getName() + " is weak: " + this.isWeak();
    }

    public int hashCode() {
        return this.format().hashCode();
    }

    public boolean isWeak() {
        return this.weak;
    }
}

