/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.resolver.PayloadCreator;
import org.codehaus.httpcache4j.resolver.ResponseResolver;

public abstract class AbstractResponseResolver
implements ResponseResolver {
    private PayloadCreator payloadCreator;

    public AbstractResponseResolver(PayloadCreator payloadCreator) {
        Validate.notNull((Object)payloadCreator, (String)"You may not add a null Payload creator");
        this.payloadCreator = payloadCreator;
    }

    protected Headers removePotentialDuplicates(Headers headersToRemoveFrom, Headers headers) {
        HashMap<String, List<Header>> map = new HashMap<String, List<Header>>(headersToRemoveFrom.getHeadersAsMap());
        for (String key : headers.getHeadersAsMap().keySet()) {
            if (!map.containsKey(key)) continue;
            map.remove(key);
        }
        if (map.isEmpty()) {
            return new Headers();
        }
        return new Headers(map);
    }

    protected PayloadCreator getPayloadCreator() {
        return this.payloadCreator;
    }
}

