/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Header
extends Parameter {
    private static final long serialVersionUID = 3652406179988246038L;
    private Map<String, String> directives = new HashMap<String, String>();

    public Header(String name, String value) {
        super(name, value);
        Validate.notEmpty((String)value, (String)"The value of a Header may not be empty");
        this.parseDirectives(value);
    }

    private void parseDirectives(String value) {
        List<String> directives = Arrays.asList(value.split(","));
        for (String directive : directives) {
            if ((directive = directive.trim()).length() <= 0) continue;
            String[] directiveParts = directive.split("=", 2);
            this.directives.put(directiveParts[0], directiveParts.length > 1 ? directiveParts[1] : null);
        }
    }

    public Map<String, String> getDirectives() {
        return Collections.unmodifiableMap(this.directives);
    }
}

