/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.preference;

import java.util.Arrays;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.HTTPUtils;
import org.codehaus.httpcache4j.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Preference<T> {
    private T preference;
    private double quality = 1.0;

    public Preference(T preference) {
        Validate.notNull(preference, (String)"Preference may not be null, use a ALL preference instead.");
        this.preference = preference;
    }

    public T getPreference() {
        return this.preference;
    }

    public double getQuality() {
        return this.quality;
    }

    public void setQuality(double quality) {
        Validate.isTrue((quality <= 1.0 && quality > 0.0 ? 1 : 0) != 0, (String)"Quality is a percentage ranging from 0.0, to 1.0");
        this.quality = quality;
    }

    public String toString() {
        StringBuilder headerValue = new StringBuilder();
        if (this.getQuality() != 1.0) {
            headerValue.append(this.getStringValue()).append(";q=").append(this.getQuality());
        } else {
            headerValue.append(this.getStringValue());
        }
        return headerValue.toString();
    }

    protected String getStringValue() {
        return this.getPreference().toString();
    }

    protected Header toHeader() {
        return HTTPUtils.toHeader(this.getHeaderName(), Arrays.asList(this));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Preference that = (Preference)o;
        return !(this.preference != null ? !this.preference.equals(that.preference) : that.preference != null);
    }

    public int hashCode() {
        return this.preference != null ? this.preference.hashCode() : 0;
    }

    protected abstract String getHeaderName();
}

