/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.HTTPUtils;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.Tag;
import org.codehaus.httpcache4j.payload.Payload;
import org.joda.time.DateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HTTPResponse
implements Serializable {
    private final Status status;
    private final Payload payload;
    private final Headers headers;
    private Tag ETag;
    private DateTime lastModified;
    private Set<HTTPMethod> allowedMethods;

    public HTTPResponse(Payload payload, Status status, Headers headers) {
        Validate.notNull((Object)status, (String)"You must supply a Status");
        Validate.notNull((Object)headers, (String)"You must supply some Headers");
        this.status = status;
        this.payload = payload;
        this.headers = headers;
        if (headers.hasHeader("ETag")) {
            this.ETag = Tag.parse(headers.getFirstHeader("ETag").getValue());
        }
        if (headers.hasHeader("Last-Modified")) {
            this.lastModified = HTTPUtils.fromHttpDate(headers.getFirstHeader("Last-Modified"));
        }
        if (headers.hasHeader("Allow")) {
            String value = headers.getFirstHeader("Allow").getValue();
            String[] parts = value.split(",");
            HashSet<HTTPMethod> allowedMethods = new HashSet<HTTPMethod>();
            for (String part : parts) {
                allowedMethods.add(HTTPMethod.valueOf(part.trim()));
            }
            this.allowedMethods = Collections.unmodifiableSet(allowedMethods);
        }
    }

    public boolean hasPayload() {
        return this.payload != null;
    }

    public Status getStatus() {
        return this.status;
    }

    public Payload getPayload() {
        return this.payload;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Tag getETag() {
        return this.ETag;
    }

    public DateTime getLastModified() {
        return this.lastModified;
    }

    public Set<HTTPMethod> getAllowedMethods() {
        return this.allowedMethods != null ? this.allowedMethods : Collections.emptySet();
    }
}

