/*
 * Decompiled with CFR 0.152.
 */
package groovy.net.xmlrpc;

import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import groovy.net.xmlrpc.RPCServerProxy;
import groovy.net.xmlrpc.XMLRPCCallFailureException;
import groovy.net.xmlrpc.XMLRPCMessageProcessor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import uk.co.wilson.net.xmlrpc.XMLRPCFailException;

public class XMLRPCServerProxy
extends RPCServerProxy {
    static final String ENCODING = "ISO-8859-1";
    static final String xmlDeclaration = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
    protected final URL serverURL;
    protected final boolean detectEncoding;
    protected String authString;

    public XMLRPCServerProxy(String string, boolean bl) throws MalformedURLException {
        this.serverURL = new URL(string);
        this.detectEncoding = bl;
    }

    public XMLRPCServerProxy(String string) throws MalformedURLException {
        this(string, false);
    }

    public Object invokeMethod(String string, Object object) {
        Object[] objectArray;
        if ("invokeMethod".equals(string)) {
            return super.invokeMethod(string, object);
        }
        Object[] objectArray2 = objectArray = object instanceof List ? ((List)object).toArray() : (Object[])object;
        if ("setBasicAuth".equals(string)) {
            try {
                this.setBasicAuth((String)objectArray[0], (String)objectArray[1]);
            }
            catch (IOException iOException) {
                throw new GroovyRuntimeException((Throwable)iOException);
            }
            return null;
        }
        int n = objectArray.length;
        if (n != 0 && objectArray[n - 1] instanceof Closure) {
            --n;
        }
        try {
            byte[] byArray = XMLRPCMessageProcessor.emitCall(new StringBuffer(xmlDeclaration), string, objectArray, n).toString().getBytes(ENCODING);
            List list = this.doRpcCall(byArray);
            if (list == null) {
                throw new XMLRPCCallFailureException("Empty response from server", new Integer(0));
            }
            if (n == objectArray.length) {
                return list.get(0);
            }
            Closure closure = (Closure)objectArray[n];
            closure.setDelegate((Object)this);
            return closure.call(new Object[]{list.get(0)});
        }
        catch (IOException iOException) {
            throw new XMLRPCCallFailureException(iOException.getMessage(), new Integer(0), iOException);
        }
        catch (XMLRPCFailException xMLRPCFailException) {
            throw new XMLRPCCallFailureException(xMLRPCFailException.getFaultString(), xMLRPCFailException.getCause(), xMLRPCFailException);
        }
    }

    protected List doRpcCall(byte[] byArray) throws IOException {
        URLConnection uRLConnection = this.serverURL.openConnection();
        uRLConnection.setDoInput(true);
        uRLConnection.setDoOutput(true);
        uRLConnection.setUseCaches(false);
        uRLConnection.setAllowUserInteraction(false);
        uRLConnection.setRequestProperty("Content-Length", Integer.toString(byArray.length));
        uRLConnection.setRequestProperty("Content-Type", "text/xml");
        if (null != this.authString) {
            uRLConnection.setRequestProperty("Authorization", this.authString);
        }
        OutputStream outputStream = uRLConnection.getOutputStream();
        outputStream.write(byArray);
        outputStream.flush();
        outputStream.close();
        XMLRPCMessageProcessor xMLRPCMessageProcessor = new XMLRPCMessageProcessor();
        try {
            if (this.detectEncoding) {
                xMLRPCMessageProcessor.parseMessage(uRLConnection.getInputStream());
            } else {
                xMLRPCMessageProcessor.parseMessage(new InputStreamReader(uRLConnection.getInputStream(), ENCODING));
            }
        }
        catch (XMLRPCFailException xMLRPCFailException) {
            throw new XMLRPCCallFailureException(xMLRPCFailException.getFaultString(), new Integer(xMLRPCFailException.getFaultCode()), xMLRPCFailException);
        }
        return xMLRPCMessageProcessor.getParams();
    }

    public void setBasicAuth(String string, String string2) throws IOException {
        String string3;
        Class<?> clazz;
        if (null == string) {
            this.authString = null;
            return;
        }
        try {
            clazz = Class.forName("org.codehaus.groovy.runtime.DefaultGroovyMethods");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("cannot find DefaultGroovyMethods?!" + classNotFoundException.getMessage());
        }
        Method method = null;
        Class[] classArray = new Class[]{byte[].class};
        try {
            method = clazz.getMethod("encodeBase64", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                clazz = Class.forName("org.codehaus.groovy.runtime.EncodingGroovyMethods");
                method = clazz.getMethod("encodeBase64", classArray);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new IOException("Can't find encodeBase64() method" + noSuchMethodException2.getMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("cannot find class EncodingGroovyMethods while DefaultGroovyMethods does not have encodeBase64() method?!" + classNotFoundException.getMessage());
            }
        }
        assert (method != null);
        String string4 = string + ":" + string2;
        Object[] objectArray = new Object[1];
        try {
            objectArray[0] = string4.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException("Error encoding auth header: " + unsupportedEncodingException.getMessage());
        }
        try {
            string3 = method.invoke(null, objectArray).toString();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("Error invoking encodeBase64() method" + illegalAccessException.getMessage());
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("Error invoking encodeBase64() method" + invocationTargetException.getMessage());
        }
        this.authString = "Basic " + string3;
    }
}

