/*
 * Decompiled with CFR 0.152.
 */
package groovy.net.xmlrpc;

import groovy.lang.Closure;
import groovy.net.xmlrpc.RPCServerProxy;
import groovy.net.xmlrpc.XMLRPCCallFailureException;
import groovy.net.xmlrpc.XMLRPCMessageProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import uk.co.wilson.net.xmlrpc.XMLRPCFailException;

public class XMLRPCServerProxy
extends RPCServerProxy {
    static final String xmlDeclaration = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
    private URL serverURL;

    public XMLRPCServerProxy(String string) throws MalformedURLException {
        this.serverURL = new URL(string);
    }

    public Object invokeMethod(String string, Object object) {
        if ("invokeMethod".equals(string)) {
            return super.invokeMethod(string, object);
        }
        Object[] objectArray = object instanceof List ? ((List)object).toArray() : (Object[])object;
        int n = objectArray.length;
        if (n != 0 && objectArray[n - 1] instanceof Closure) {
            --n;
        }
        try {
            byte[] byArray = XMLRPCMessageProcessor.emitCall(new StringBuffer(xmlDeclaration), string, objectArray, n).toString().getBytes("ISO-8859-1");
            URLConnection uRLConnection = this.serverURL.openConnection();
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            uRLConnection.setAllowUserInteraction(false);
            uRLConnection.setRequestProperty("Content-Length", Integer.toString(byArray.length));
            uRLConnection.setRequestProperty("Content-Type", "text/xml");
            OutputStream outputStream = uRLConnection.getOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
            outputStream.close();
            XMLRPCMessageProcessor xMLRPCMessageProcessor = new XMLRPCMessageProcessor();
            try {
                xMLRPCMessageProcessor.parseMessage(uRLConnection.getInputStream());
            }
            catch (XMLRPCFailException xMLRPCFailException) {
                throw new XMLRPCCallFailureException(xMLRPCFailException.getFaultString(), new Integer(xMLRPCFailException.getFaultCode()), xMLRPCFailException);
            }
            List list = xMLRPCMessageProcessor.getParams();
            if (list == null) {
                throw new XMLRPCCallFailureException("Empty response from server", new Integer(0));
            }
            if (n == objectArray.length) {
                return list.get(0);
            }
            Closure closure = (Closure)objectArray[n];
            closure.setDelegate((Object)this);
            return closure.call(new Object[]{list.get(0)});
        }
        catch (IOException iOException) {
            throw new XMLRPCCallFailureException(iOException.getMessage(), new Integer(0), iOException);
        }
        catch (XMLRPCFailException xMLRPCFailException) {
            throw new XMLRPCCallFailureException(xMLRPCFailException.getFaultString(), xMLRPCFailException.getCause(), xMLRPCFailException);
        }
    }
}

