/*
 * Decompiled with CFR 0.152.
 */
package groovy.text.markup;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Writable;
import groovy.text.Template;
import groovy.text.TemplateEngine;
import groovy.text.markup.AutoNewLineTransformer;
import groovy.text.markup.BaseTemplate;
import groovy.text.markup.TemplateASTTransformer;
import groovy.text.markup.TemplateConfiguration;
import groovy.transform.CompileStatic;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class MarkupTemplateEngine
extends TemplateEngine {
    static final ClassNode MARKUPTEMPLATEENGINE_CLASSNODE = ClassHelper.make(MarkupTemplateEngine.class);
    static final String MODELTYPES_ASTKEY = "MTE.modelTypes";
    private static final Pattern LOCALIZED_RESOURCE_PATTERN = Pattern.compile("(.+?)(?:_([a-z]{2}(?:_[A-Z]{2,3})))?\\.(\\p{Alnum}+)");
    private static final AtomicLong counter = new AtomicLong();
    private final TemplateGroovyClassLoader groovyClassLoader;
    private final CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
    private final TemplateConfiguration templateConfiguration;

    public MarkupTemplateEngine(TemplateConfiguration tplConfig) {
        this(MarkupTemplateEngine.class.getClassLoader(), tplConfig);
    }

    public MarkupTemplateEngine(final ClassLoader parentLoader, TemplateConfiguration tplConfig) {
        this.templateConfiguration = tplConfig;
        this.compilerConfiguration.addCompilationCustomizers(new CompilationCustomizer[]{new TemplateASTTransformer(tplConfig)});
        this.compilerConfiguration.addCompilationCustomizers(new CompilationCustomizer[]{new ASTTransformationCustomizer(Collections.singletonMap("extensions", "groovy.text.markup.MarkupTemplateTypeCheckingExtension"), CompileStatic.class)});
        if (this.templateConfiguration.isAutoNewLine()) {
            this.compilerConfiguration.addCompilationCustomizers(new CompilationCustomizer[]{new CompilationCustomizer(CompilePhase.CONVERSION){

                public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
                    new AutoNewLineTransformer(source).visitClass(classNode);
                }
            }});
        }
        this.groovyClassLoader = AccessController.doPrivileged(new PrivilegedAction<TemplateGroovyClassLoader>(){

            @Override
            public TemplateGroovyClassLoader run() {
                return new TemplateGroovyClassLoader(parentLoader, MarkupTemplateEngine.this.compilerConfiguration);
            }
        });
    }

    public MarkupTemplateEngine(ClassLoader parentLoader, File templateDirectory, TemplateConfiguration tplConfig) {
        this(new URLClassLoader(MarkupTemplateEngine.buildURLs(templateDirectory), parentLoader), tplConfig);
    }

    private static URL[] buildURLs(File templateDirectory) {
        try {
            return new URL[]{templateDirectory.toURI().toURL()};
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid directory", e);
        }
    }

    @Override
    public Template createTemplate(Reader reader) throws CompilationFailedException, ClassNotFoundException, IOException {
        return new MarkupTemplateMaker(reader, null);
    }

    public Template createTemplateByPath(String templatePath) throws CompilationFailedException, ClassNotFoundException, IOException {
        return new MarkupTemplateMaker(this.resolveTemplate(templatePath), null);
    }

    public Template createTypeCheckedModelTemplate(String source, Map<String, String> modelTypes) throws CompilationFailedException, ClassNotFoundException, IOException {
        return new MarkupTemplateMaker(new StringReader(source), modelTypes);
    }

    public Template createTypeCheckedModelTemplate(Reader reader, Map<String, String> modelTypes) throws CompilationFailedException, ClassNotFoundException, IOException {
        return new MarkupTemplateMaker(reader, modelTypes);
    }

    public Template createTypeCheckedModelTemplateByPath(String templatePath, Map<String, String> modelTypes) throws CompilationFailedException, ClassNotFoundException, IOException {
        return new MarkupTemplateMaker(this.resolveTemplate(templatePath), modelTypes);
    }

    @Override
    public Template createTemplate(URL resource) throws CompilationFailedException, ClassNotFoundException, IOException {
        return new MarkupTemplateMaker(resource, null);
    }

    public Template createTypeCheckedModelTemplate(URL resource, Map<String, String> modelTypes) throws CompilationFailedException, ClassNotFoundException, IOException {
        return new MarkupTemplateMaker(resource, modelTypes);
    }

    public GroovyClassLoader getTemplateLoader() {
        return this.groovyClassLoader;
    }

    public CompilerConfiguration getCompilerConfiguration() {
        return this.compilerConfiguration;
    }

    public TemplateConfiguration getTemplateConfiguration() {
        return this.templateConfiguration;
    }

    URL resolveTemplate(String templatePath) throws IOException {
        URL resource;
        TemplateResource templateResource = TemplateResource.parse(templatePath);
        String configurationLocale = this.templateConfiguration.getLocale().toString().replace("-", "_");
        URL uRL = resource = templateResource.hasLocale() ? this.groovyClassLoader.getResource(templateResource.toString()) : null;
        if (resource == null) {
            resource = this.groovyClassLoader.getResource(templateResource.withLocale(configurationLocale).toString());
        }
        if (resource == null) {
            resource = this.groovyClassLoader.getResource(templateResource.withLocale(null).toString());
        }
        if (resource == null) {
            throw new IOException("Unable to load template:" + templatePath);
        }
        return resource;
    }

    public static class TemplateResource {
        private final String baseName;
        private final String locale;
        private final String extension;

        public static TemplateResource parse(String fullPath) {
            Matcher matcher = LOCALIZED_RESOURCE_PATTERN.matcher(fullPath);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Illegal template path: " + fullPath);
            }
            return new TemplateResource(matcher.group(1), matcher.group(2), matcher.group(3));
        }

        private TemplateResource(String baseName, String locale, String extension) {
            this.baseName = baseName;
            this.locale = locale;
            this.extension = extension;
        }

        public TemplateResource withLocale(String locale) {
            return new TemplateResource(this.baseName, locale, this.extension);
        }

        public String toString() {
            return this.baseName + (this.locale != null ? "_" + this.locale : "") + "." + this.extension;
        }

        public boolean hasLocale() {
            return this.locale != null && !"".equals(this.locale);
        }
    }

    static class TemplateGroovyClassLoader
    extends GroovyClassLoader {
        static final ThreadLocal<Map<String, String>> modelTypes = new ThreadLocal();

        public TemplateGroovyClassLoader(ClassLoader parentLoader, CompilerConfiguration compilerConfiguration) {
            super(parentLoader, compilerConfiguration);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class parseClass(GroovyCodeSource codeSource, Map<String, String> hints) throws CompilationFailedException {
            modelTypes.set(hints);
            try {
                Class clazz = super.parseClass(codeSource);
                return clazz;
            }
            finally {
                modelTypes.set(null);
            }
        }
    }

    private class MarkupTemplateMaker
    implements Template {
        final Class<BaseTemplate> templateClass;
        final Map<String, String> modeltypes;

        public MarkupTemplateMaker(Reader reader, Map<String, String> modelTypes) {
            this.templateClass = MarkupTemplateEngine.this.groovyClassLoader.parseClass(new GroovyCodeSource(reader, "GeneratedMarkupTemplate" + counter.getAndIncrement(), ""), modelTypes);
            this.modeltypes = modelTypes;
        }

        public MarkupTemplateMaker(URL resource, Map<String, String> modelTypes) throws IOException {
            this.templateClass = MarkupTemplateEngine.this.groovyClassLoader.parseClass(new GroovyCodeSource(resource), modelTypes);
            this.modeltypes = modelTypes;
        }

        @Override
        public Writable make() {
            return this.make(Collections.emptyMap());
        }

        @Override
        public Writable make(Map binding) {
            return (Writable)DefaultGroovyMethods.newInstance(this.templateClass, (Object[])new Object[]{MarkupTemplateEngine.this, binding, this.modeltypes, MarkupTemplateEngine.this.templateConfiguration});
        }
    }
}

