/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.macro.transform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.macro.runtime.Macro;
import org.codehaus.groovy.runtime.m12n.ExtensionModule;
import org.codehaus.groovy.runtime.m12n.ExtensionModuleScanner;
import org.codehaus.groovy.runtime.m12n.MetaInfExtensionModule;
import org.codehaus.groovy.runtime.memoize.EvictableCache;
import org.codehaus.groovy.runtime.memoize.MemoizeCache;
import org.codehaus.groovy.runtime.memoize.StampedCommonCache;
import org.codehaus.groovy.transform.stc.ExtensionMethodNode;

class MacroMethodsCache {
    private static final ClassNode MACRO_ANNOTATION_CLASS_NODE = ClassHelper.make(Macro.class);
    private static final EvictableCache<ClassLoader, Map<String, List<MethodNode>>> CACHE = new StampedCommonCache(new WeakHashMap());

    MacroMethodsCache() {
    }

    public static Map<String, List<MethodNode>> get(ClassLoader classLoader) {
        return (Map)CACHE.getAndPut((Object)classLoader, (MemoizeCache.ValueProvider)new MemoizeCache.ValueProvider<ClassLoader, Map<String, List<MethodNode>>>(){

            public Map<String, List<MethodNode>> provide(ClassLoader key) {
                return Collections.unmodifiableMap(MacroMethodsCache.getMacroMethodsFromClassLoader(key));
            }
        });
    }

    protected static Map<String, List<MethodNode>> getMacroMethodsFromClassLoader(ClassLoader classLoader) {
        final HashMap result = new HashMap();
        ExtensionModuleScanner.ExtensionModuleListener listener = new ExtensionModuleScanner.ExtensionModuleListener(){

            public void onModule(ExtensionModule module) {
                if (!(module instanceof MetaInfExtensionModule)) {
                    return;
                }
                MetaInfExtensionModule extensionModule = (MetaInfExtensionModule)module;
                MacroMethodsCache.scanExtClasses(result, extensionModule.getInstanceMethodsExtensionClasses(), false);
                MacroMethodsCache.scanExtClasses(result, extensionModule.getStaticMethodsExtensionClasses(), true);
            }
        };
        ExtensionModuleScanner macroModuleScanner = new ExtensionModuleScanner(listener, classLoader);
        macroModuleScanner.scanClasspathModules();
        for (Map.Entry entry : result.entrySet()) {
            result.put(entry.getKey(), Collections.unmodifiableList((List)entry.getValue()));
        }
        return Collections.unmodifiableMap(result);
    }

    private static void scanExtClasses(Map<String, List<MethodNode>> accumulator, List<Class> classes, boolean isStatic) {
        for (Class dgmLikeClass : classes) {
            ClassNode cn = ClassHelper.makeWithoutCaching((Class)dgmLikeClass, (boolean)true);
            for (MethodNode metaMethod : cn.getMethods()) {
                Parameter[] types = metaMethod.getParameters();
                if (!metaMethod.isStatic() || !metaMethod.isPublic() || types.length == 0 || metaMethod.getAnnotations(MACRO_ANNOTATION_CLASS_NODE).isEmpty()) continue;
                Parameter[] parameters = new Parameter[types.length - 1];
                System.arraycopy(types, 1, parameters, 0, parameters.length);
                ExtensionMethodNode node = new ExtensionMethodNode(metaMethod, metaMethod.getName(), metaMethod.getModifiers(), metaMethod.getReturnType(), parameters, ClassNode.EMPTY_ARRAY, null, isStatic);
                node.setGenericsTypes(metaMethod.getGenericsTypes());
                ClassNode declaringClass = types[0].getType();
                node.setDeclaringClass(declaringClass);
                List<MethodNode> macroMethods = accumulator.get(metaMethod.getName());
                if (macroMethods == null) {
                    macroMethods = new ArrayList<MethodNode>();
                    accumulator.put(metaMethod.getName(), macroMethods);
                }
                macroMethods.add((MethodNode)node);
            }
        }
    }
}

