/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools.groovydoc;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.groovy.antlr.SourceBuffer;
import org.codehaus.groovy.antlr.UnicodeEscapingReader;
import org.codehaus.groovy.antlr.java.Groovifier;
import org.codehaus.groovy.antlr.java.Java2GroovyConverter;
import org.codehaus.groovy.antlr.java.JavaLexer;
import org.codehaus.groovy.antlr.java.JavaRecognizer;
import org.codehaus.groovy.antlr.parser.GroovyLexer;
import org.codehaus.groovy.antlr.parser.GroovyRecognizer;
import org.codehaus.groovy.antlr.treewalker.PreOrderTraversal;
import org.codehaus.groovy.antlr.treewalker.SourceCodeTraversal;
import org.codehaus.groovy.groovydoc.GroovyClassDoc;
import org.codehaus.groovy.groovydoc.GroovyRootDoc;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.tools.groovydoc.GroovyDocTool;
import org.codehaus.groovy.tools.groovydoc.LinkArgument;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyClassDocAssembler;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyPackageDoc;
import org.codehaus.groovy.tools.groovydoc.SimpleGroovyRootDoc;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyRootDocBuilder {
    private static final char FS = '/';
    private List<LinkArgument> links;
    private final GroovyDocTool tool;
    private final String[] sourcepaths;
    private final SimpleGroovyRootDoc rootDoc;
    private final Properties properties;

    public GroovyRootDocBuilder(GroovyDocTool tool, String[] sourcepaths, List<LinkArgument> links, Properties properties) {
        this.tool = tool;
        this.sourcepaths = sourcepaths;
        this.links = links;
        this.rootDoc = new SimpleGroovyRootDoc("root");
        this.properties = properties;
    }

    public Map<String, GroovyClassDoc> getClassDocsFromSingleSource(String packagePath, String file, String src) throws RecognitionException, TokenStreamException {
        if (file.indexOf(".java") > 0) {
            return this.parseJava(packagePath, file, src);
        }
        if (file.indexOf(".sourcefile") > 0) {
            return this.parseJava(packagePath, file, src);
        }
        return this.parseGroovy(packagePath, file, src);
    }

    private Map<String, GroovyClassDoc> parseJava(String packagePath, String file, String src) throws RecognitionException, TokenStreamException {
        SourceBuffer sourceBuffer = new SourceBuffer();
        JavaRecognizer parser = this.getJavaParser(src, sourceBuffer);
        String[] tokenNames = parser.getTokenNames();
        try {
            parser.compilationUnit();
        }
        catch (OutOfMemoryError e) {
            System.out.println(new StringBuffer().append("Out of memory while processing: ").append(packagePath).append("/").append(file).toString());
            throw e;
        }
        AST ast = parser.getAST();
        Java2GroovyConverter java2groovyConverter = new Java2GroovyConverter(tokenNames);
        PreOrderTraversal java2groovyTraverser = new PreOrderTraversal(java2groovyConverter);
        java2groovyTraverser.process(ast);
        Groovifier groovifier = new Groovifier(tokenNames);
        PreOrderTraversal groovifierTraverser = new PreOrderTraversal(groovifier);
        groovifierTraverser.process(ast);
        SimpleGroovyClassDocAssembler visitor = new SimpleGroovyClassDocAssembler(packagePath, file, sourceBuffer, this.links, this.properties, false);
        SourceCodeTraversal traverser = new SourceCodeTraversal(visitor);
        traverser.process(ast);
        return visitor.getGroovyClassDocs();
    }

    private Map<String, GroovyClassDoc> parseGroovy(String packagePath, String file, String src) throws RecognitionException, TokenStreamException {
        SourceBuffer sourceBuffer = new SourceBuffer();
        GroovyRecognizer parser = this.getGroovyParser(src, sourceBuffer);
        try {
            parser.compilationUnit();
        }
        catch (OutOfMemoryError e) {
            System.out.println(new StringBuffer().append("Out of memory while processing: ").append(packagePath).append("/").append(file).toString());
            throw e;
        }
        AST ast = parser.getAST();
        SimpleGroovyClassDocAssembler visitor = new SimpleGroovyClassDocAssembler(packagePath, file, sourceBuffer, this.links, this.properties, true);
        SourceCodeTraversal traverser = new SourceCodeTraversal(visitor);
        traverser.process(ast);
        return visitor.getGroovyClassDocs();
    }

    private JavaRecognizer getJavaParser(String input, SourceBuffer sourceBuffer) {
        UnicodeEscapingReader unicodeReader = new UnicodeEscapingReader(new StringReader(input), sourceBuffer);
        JavaLexer lexer = new JavaLexer(unicodeReader);
        unicodeReader.setLexer(lexer);
        JavaRecognizer parser = JavaRecognizer.make(lexer);
        parser.setSourceBuffer(sourceBuffer);
        return parser;
    }

    private GroovyRecognizer getGroovyParser(String input, SourceBuffer sourceBuffer) {
        UnicodeEscapingReader unicodeReader = new UnicodeEscapingReader(new StringReader(input), sourceBuffer);
        GroovyLexer lexer = new GroovyLexer(unicodeReader);
        unicodeReader.setLexer(lexer);
        GroovyRecognizer parser = GroovyRecognizer.make(lexer);
        parser.setSourceBuffer(sourceBuffer);
        return parser;
    }

    public void buildTree(List<String> filenames) throws IOException, RecognitionException, TokenStreamException {
        this.setOverview();
        ArrayList<File> sourcepathFiles = new ArrayList<File>();
        for (String sourcepath : this.sourcepaths) {
            sourcepathFiles.add(new File(sourcepath).getAbsoluteFile());
        }
        block1: for (String filename : filenames) {
            for (File spath : sourcepathFiles) {
                File srcFile = new File(spath, filename);
                if (!srcFile.exists()) continue;
                this.processFile(filename, srcFile);
                continue block1;
            }
        }
    }

    private void setOverview() {
        String path = this.properties.getProperty("overviewFile");
        if (path != null && path.length() > 0) {
            try {
                String content = DefaultGroovyMethods.getText(new File(path));
                this.calcThenSetOverviewDescription(content);
            }
            catch (IOException e) {
                System.err.println(new StringBuffer().append("Unable to load overview file: ").append(e.getMessage()).toString());
            }
        }
    }

    private void processFile(String filename, File srcFile) throws IOException {
        String src = DefaultGroovyMethods.getText(srcFile);
        String packagePath = this.tool.getPath(filename).replace('\\', '/');
        String file = this.tool.getFile(filename);
        SimpleGroovyPackageDoc packageDoc = (SimpleGroovyPackageDoc)this.rootDoc.packageNamed(packagePath);
        if (packageDoc == null) {
            packageDoc = new SimpleGroovyPackageDoc(packagePath);
        }
        if (filename.endsWith("package.html") || filename.endsWith("package-info.java") || filename.endsWith("package-info.groovy")) {
            this.processPackageInfo(src, filename, packageDoc);
            this.rootDoc.put(packagePath, packageDoc);
            return;
        }
        try {
            Map<String, GroovyClassDoc> classDocs = this.getClassDocsFromSingleSource(packagePath, file, src);
            this.rootDoc.putAllClasses(classDocs);
            packageDoc.putAll(classDocs);
            this.rootDoc.put(packagePath, packageDoc);
        }
        catch (RecognitionException e) {
            System.err.println(new StringBuffer().append("ignored due to RecognitionException: ").append(filename).append(" [").append(e.getMessage()).append("]").toString());
        }
        catch (TokenStreamException e) {
            System.err.println(new StringBuffer().append("ignored due to TokenStreamException: ").append(filename).append(" [").append(e.getMessage()).append("]").toString());
        }
    }

    void processPackageInfo(String src, String filename, SimpleGroovyPackageDoc packageDoc) {
        String description = this.calcThenSetPackageDescription(src, filename, packageDoc);
        this.calcThenSetSummary(description, packageDoc);
    }

    private String calcThenSetPackageDescription(String src, String filename, SimpleGroovyPackageDoc packageDoc) {
        String description = filename.endsWith(".html") ? this.scrubOffExcessiveTags(src) : this.trimPackageAndComments(src);
        packageDoc.setDescription(description);
        return description;
    }

    private void calcThenSetSummary(String src, SimpleGroovyPackageDoc packageDoc) {
        packageDoc.setSummary(SimpleGroovyDoc.calculateFirstSentence(src));
    }

    private void calcThenSetOverviewDescription(String src) {
        String description = this.scrubOffExcessiveTags(src);
        this.rootDoc.setDescription(description);
    }

    private String trimPackageAndComments(String src) {
        return src.replaceFirst("(?sm)^package.*", "").replaceFirst("(?sm)/\\*\\*(.*)\\*/", "$1").replaceAll("(?m)^\\s*\\*", "");
    }

    private String scrubOffExcessiveTags(String src) {
        String description = this.pruneTagFromFront(src, "html");
        description = this.pruneTagFromFront(description, "/head");
        description = this.pruneTagFromFront(description, "body");
        description = this.pruneTagFromFront(description, "p");
        description = this.pruneTagFromEnd(description, "/p");
        description = this.pruneTagFromEnd(description, "/html");
        return this.pruneTagFromEnd(description, "/body");
    }

    private String pruneTagFromFront(String description, String tag) {
        int index = Math.max(this.indexOfTag(description, tag.toLowerCase()), this.indexOfTag(description, tag.toUpperCase()));
        if (index < 0) {
            return description;
        }
        return description.substring(index);
    }

    private String pruneTagFromEnd(String description, String tag) {
        int index = Math.max(description.indexOf(new StringBuffer().append("<").append(tag.toLowerCase()).append(">").toString()), description.indexOf(new StringBuffer().append("<").append(tag.toUpperCase()).append(">").toString()));
        if (index < 0) {
            return description;
        }
        return description.substring(0, index);
    }

    private int indexOfTag(String text, String tag) {
        int pos = text.indexOf(new StringBuffer().append("<").append(tag).append(">").toString());
        if (pos > 0) {
            pos += tag.length() + 2;
        }
        return pos;
    }

    public GroovyRootDoc getRootDoc() {
        this.rootDoc.resolve();
        return this.rootDoc;
    }
}

