/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public class StaticImportVisitor
extends ClassCodeExpressionTransformer {
    private ClassNode currentClass;
    private MethodNode currentMethod;
    private SourceUnit source;
    private CompilationUnit compilationUnit;
    private boolean stillResolving;
    private boolean inSpecialConstructorCall;
    private boolean inClosure;
    private boolean inPropertyExpression;
    private Expression foundConstant;
    private Expression foundArgs;
    static /* synthetic */ Class class$org$codehaus$groovy$ast$expr$VariableExpression;
    static /* synthetic */ Class class$org$codehaus$groovy$ast$expr$ClosureExpression;
    static /* synthetic */ Class class$org$codehaus$groovy$ast$expr$ConstructorCallExpression;
    static /* synthetic */ Class class$org$codehaus$groovy$ast$expr$PropertyExpression;
    static /* synthetic */ Class class$org$codehaus$groovy$ast$expr$ConstantExpression;
    static /* synthetic */ Class class$org$codehaus$groovy$ast$expr$ArgumentListExpression;
    static /* synthetic */ Class class$org$codehaus$groovy$ast$expr$MethodCallExpression;

    public StaticImportVisitor(CompilationUnit cu) {
        this.compilationUnit = cu;
    }

    public void visitClass(ClassNode node, SourceUnit source) {
        this.currentClass = node;
        this.source = source;
        super.visitClass(node);
    }

    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        this.currentMethod = node;
        super.visitConstructorOrMethod(node, isConstructor);
        this.currentMethod = null;
    }

    public Expression transform(Expression exp) {
        if (exp == null) {
            return null;
        }
        Class<?> clazz = exp.getClass();
        Class<?> clazz2 = class$org$codehaus$groovy$ast$expr$VariableExpression;
        if (clazz2 == null) {
            clazz2 = class$org$codehaus$groovy$ast$expr$VariableExpression = new VariableExpression[0].getClass().getComponentType();
        }
        if (clazz == clazz2) {
            return this.transformVariableExpression((VariableExpression)exp);
        }
        Class<?> clazz3 = exp.getClass();
        Class<?> clazz4 = class$org$codehaus$groovy$ast$expr$PropertyExpression;
        if (clazz4 == null) {
            clazz4 = class$org$codehaus$groovy$ast$expr$PropertyExpression = new PropertyExpression[0].getClass().getComponentType();
        }
        if (clazz3 == clazz4) {
            return this.transformPropertyExpression((PropertyExpression)exp);
        }
        Class<?> clazz5 = exp.getClass();
        Class<?> clazz6 = class$org$codehaus$groovy$ast$expr$MethodCallExpression;
        if (clazz6 == null) {
            clazz6 = class$org$codehaus$groovy$ast$expr$MethodCallExpression = new MethodCallExpression[0].getClass().getComponentType();
        }
        if (clazz5 == clazz6) {
            return this.transformMethodCallExpression((MethodCallExpression)exp);
        }
        Class<?> clazz7 = exp.getClass();
        Class<?> clazz8 = class$org$codehaus$groovy$ast$expr$ClosureExpression;
        if (clazz8 == null) {
            clazz8 = class$org$codehaus$groovy$ast$expr$ClosureExpression = new ClosureExpression[0].getClass().getComponentType();
        }
        if (clazz7 == clazz8) {
            return this.transformClosureExpression((ClosureExpression)exp);
        }
        Class<?> clazz9 = exp.getClass();
        Class<?> clazz10 = class$org$codehaus$groovy$ast$expr$ConstructorCallExpression;
        if (clazz10 == null) {
            clazz10 = class$org$codehaus$groovy$ast$expr$ConstructorCallExpression = new ConstructorCallExpression[0].getClass().getComponentType();
        }
        if (clazz9 == clazz10) {
            return this.transformConstructorCallExpression((ConstructorCallExpression)exp);
        }
        Class<?> clazz11 = exp.getClass();
        Class<?> clazz12 = class$org$codehaus$groovy$ast$expr$ArgumentListExpression;
        if (clazz12 == null) {
            clazz12 = class$org$codehaus$groovy$ast$expr$ArgumentListExpression = new ArgumentListExpression[0].getClass().getComponentType();
        }
        if (clazz11 == clazz12) {
            Expression result = exp.transformExpression(this);
            if (this.inPropertyExpression) {
                this.foundArgs = result;
            }
            return result;
        }
        Class<?> clazz13 = exp.getClass();
        Class<?> clazz14 = class$org$codehaus$groovy$ast$expr$ConstantExpression;
        if (clazz14 == null) {
            clazz14 = class$org$codehaus$groovy$ast$expr$ConstantExpression = new ConstantExpression[0].getClass().getComponentType();
        }
        if (clazz13 == clazz14) {
            Expression result = exp.transformExpression(this);
            if (this.inPropertyExpression) {
                this.foundConstant = result;
            }
            return result;
        }
        return exp.transformExpression(this);
    }

    protected Expression transformVariableExpression(VariableExpression ve) {
        Variable v = ve.getAccessedVariable();
        if (v != null && v instanceof DynamicVariable) {
            Expression result = this.findStaticFieldImportFromModule(v.getName());
            if (result != null) {
                result.setSourcePosition(ve);
                return result;
            }
            if (!this.inPropertyExpression || this.inSpecialConstructorCall) {
                this.addStaticVariableError(ve);
            }
        }
        return ve;
    }

    protected Expression transformMethodCallExpression(MethodCallExpression mce) {
        Expression args = this.transform(mce.getArguments());
        Expression method = this.transform(mce.getMethod());
        Expression object = this.transform(mce.getObjectExpression());
        boolean isExplicitThisOrSuper = false;
        if (object instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)object;
            boolean bl = isExplicitThisOrSuper = !mce.isImplicitThis() && (ve.getName().equals("this") || ve.getName().equals("super"));
        }
        if (mce.isImplicitThis() || isExplicitThisOrSuper) {
            ConstantExpression ce;
            Object value;
            Expression ret;
            if (mce.isImplicitThis() && (ret = this.findStaticMethodImportFromModule(method, args)) != null) {
                ret.setSourcePosition(mce);
                return ret;
            }
            if (method instanceof ConstantExpression && (value = (ce = (ConstantExpression)method).getValue()) instanceof String) {
                String methodName = (String)value;
                boolean lookForPossibleStaticMethod = true;
                if (this.currentMethod != null && !this.currentMethod.isStatic() && this.currentClass.hasPossibleMethod(methodName, args)) {
                    lookForPossibleStaticMethod = false;
                }
                if (this.inSpecialConstructorCall || lookForPossibleStaticMethod && this.currentClass.hasPossibleStaticMethod(methodName, args)) {
                    StaticMethodCallExpression smce = new StaticMethodCallExpression(this.currentClass, methodName, args);
                    smce.setSourcePosition(mce);
                    return smce;
                }
            }
        }
        MethodCallExpression result = new MethodCallExpression(object, method, args);
        result.setSafe(mce.isSafe());
        result.setImplicitThis(mce.isImplicitThis());
        result.setSpreadSafe(mce.isSpreadSafe());
        result.setSourcePosition(mce);
        return result;
    }

    protected Expression transformConstructorCallExpression(ConstructorCallExpression cce) {
        this.inSpecialConstructorCall = cce.isSpecialCall();
        Expression ret = cce.transformExpression(this);
        this.inSpecialConstructorCall = false;
        return ret;
    }

    protected Expression transformClosureExpression(ClosureExpression ce) {
        boolean oldInClosure = this.inClosure;
        this.inClosure = true;
        Statement code = ce.getCode();
        if (code != null) {
            code.visit(this);
        }
        this.inClosure = oldInClosure;
        return ce;
    }

    protected Expression transformPropertyExpression(PropertyExpression pe) {
        Expression result;
        VariableExpression ve;
        boolean isExplicitSuper;
        FieldNode field;
        ClassExpression ce;
        boolean oldInPropertyExpression = this.inPropertyExpression;
        Expression oldFoundArgs = this.foundArgs;
        Expression oldFoundMethod = this.foundConstant;
        this.inPropertyExpression = true;
        this.foundArgs = null;
        this.foundConstant = null;
        Expression objectExpression = this.transform(pe.getObjectExpression());
        if (objectExpression instanceof ClassExpression && this.currentMethod != null && this.currentMethod.isStatic() && (ce = (ClassExpression)objectExpression).getType().getName().equals(this.currentClass.getName()) && (field = this.currentClass.getDeclaredField(pe.getPropertyAsString())) != null && field.isStatic()) {
            FieldExpression expression = new FieldExpression(field);
            expression.setSourcePosition(pe);
            return expression;
        }
        if (objectExpression instanceof VariableExpression && (isExplicitSuper = (ve = (VariableExpression)objectExpression).getName().equals("super")) && this.currentMethod != null && this.currentMethod.isStatic()) {
            this.addError("'super' cannot be used in a static context, ex the exlicit class instead.", pe);
            return null;
        }
        if (this.foundArgs != null && this.foundConstant != null && (result = this.findStaticMethodImportFromModule(this.foundConstant, this.foundArgs)) != null) {
            objectExpression = result;
        }
        this.inPropertyExpression = oldInPropertyExpression;
        this.foundArgs = oldFoundArgs;
        this.foundConstant = oldFoundMethod;
        pe.setObjectExpression(objectExpression);
        if (!this.inSpecialConstructorCall) {
            this.checkStaticScope(pe);
        }
        return pe;
    }

    private void checkStaticScope(PropertyExpression pe) {
        if (this.inClosure) {
            return;
        }
        for (Expression it = pe; it != null; it = it.getObjectExpression()) {
            if (it instanceof PropertyExpression) continue;
            if (it instanceof VariableExpression) {
                this.addStaticVariableError((VariableExpression)it);
            }
            return;
        }
    }

    private void addStaticVariableError(VariableExpression ve) {
        if (!(this.inSpecialConstructorCall || !this.inClosure && ve.isInStaticContext())) {
            return;
        }
        if (this.stillResolving) {
            return;
        }
        if (ve.isThisExpression() || ve.isSuperExpression()) {
            return;
        }
        Variable v = ve.getAccessedVariable();
        if (v != null && !(v instanceof DynamicVariable) && v.isInStaticContext()) {
            return;
        }
        this.addError("Apparent variable '" + ve.getName() + "' was found in a static scope but doesn't refer" + " to a local variable, static field or class. Possible causes:\n" + "You attempted to reference a variable in the binding or an instance variable from a static context.\n" + "You misspelled a classname or statically imported field. Please check the spelling.\n" + "You attempted to use a method '" + ve.getName() + "' but left out brackets in a place not allowed by the grammar.", ve);
    }

    private Expression findStaticFieldImportFromModule(String name) {
        Map fields;
        String fieldName;
        ClassNode node;
        Expression expression;
        ModuleNode module = this.currentClass.getModule();
        if (module == null) {
            return null;
        }
        Map aliases = module.getStaticImportAliases();
        this.stillResolving = false;
        if (aliases.containsKey(name) && (expression = this.findStaticField(node = (ClassNode)aliases.get(name), fieldName = (String)(fields = module.getStaticImportFields()).get(name))) != null) {
            return expression;
        }
        Map importedClasses = module.getStaticImportClasses();
        Iterator i$ = importedClasses.keySet().iterator();
        while (i$.hasNext()) {
            Object o = i$.next();
            String className = (String)o;
            ClassNode node2 = (ClassNode)importedClasses.get(className);
            Expression expression2 = this.findStaticField(node2, name);
            if (expression2 == null) continue;
            return expression2;
        }
        return null;
    }

    private Expression findStaticField(ClassNode staticImportType, String fieldName) {
        if (staticImportType.isPrimaryClassNode() || staticImportType.isResolved()) {
            staticImportType.getFields();
            FieldNode field = staticImportType.getField(fieldName);
            if (field != null && field.isStatic()) {
                return new PropertyExpression((Expression)new ClassExpression(staticImportType), fieldName);
            }
        } else {
            this.stillResolving = true;
        }
        return null;
    }

    private Expression findStaticMethodImportFromModule(Expression method, Expression args) {
        Map fields;
        String fieldName;
        ClassNode node;
        Expression expression;
        ModuleNode module = this.currentClass.getModule();
        if (module == null || !(method instanceof ConstantExpression)) {
            return null;
        }
        Map aliases = module.getStaticImportAliases();
        ConstantExpression ce = (ConstantExpression)method;
        Object value = ce.getValue();
        if (!(value instanceof String)) {
            return null;
        }
        String name = (String)value;
        if (aliases.containsKey(name) && (expression = this.findStaticMethod(node = (ClassNode)aliases.get(name), fieldName = (String)(fields = module.getStaticImportFields()).get(name), args)) != null) {
            return expression;
        }
        Map importPackages = module.getStaticImportClasses();
        Iterator i$ = importPackages.keySet().iterator();
        while (i$.hasNext()) {
            Object o = i$.next();
            String className = (String)o;
            ClassNode starImportType = null;
            starImportType = this.isEnum(this.currentClass) && importPackages.containsKey(this.currentClass.getName()) ? (ClassNode)importPackages.get(this.currentClass.getName()) : (ClassNode)importPackages.get(className);
            Expression expression2 = this.findStaticMethod(starImportType, name, args);
            if (expression2 == null) continue;
            return expression2;
        }
        return null;
    }

    private Expression findStaticMethod(ClassNode staticImportType, String methodName, Expression args) {
        if ((staticImportType.isPrimaryClassNode() || staticImportType.isResolved()) && staticImportType.hasPossibleStaticMethod(methodName, args)) {
            return new StaticMethodCallExpression(staticImportType, methodName, args);
        }
        return null;
    }

    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    private boolean isEnum(ClassNode node) {
        return (node.getModifiers() & 0x4000) != 0;
    }
}

